% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-collinearity-diagnostics.R
\name{ols_coll_diag}
\alias{ols_coll_diag}
\alias{ols_eigen_cindex}
\alias{ols_vif_tol}
\title{Collinearity Diagnostics}
\usage{
ols_coll_diag(model)

ols_vif_tol(model)

ols_eigen_cindex(model)
}
\arguments{
\item{model}{an object of class \code{lm}}
}
\value{
\code{ols_coll_diag} returns an object of class \code{"ols_coll_diag"}.
An object of class \code{"ols_coll_diag"} is a list containing the
following components:

\item{vif_t}{tolerance and variance inflation factors}
\item{eig_cindex}{eigen values and condition index}
}
\description{
Variance inflation factor, tolerance, eigenvalues and condition indices.
}
\details{
Collinearity implies two variables are near perfect linear combinations of one another. 
Multicollinearity involves more than two variables. In the presence of multicollinearity, regression 
estimates are unstable and have high standard errors.

\emph{Tolerance}

Percent of variance in the predictor that cannot be accounted for by other predictors.

Steps to calculate tolerance:

\itemize{
  \item Regress the kth predictor on rest of the predictors in the model.
  \item Compute \eqn{R^2} - the coefficient of determination from the regression in the above step.
  \item \eqn{Tolerance = 1 - R^2}
}

\emph{Variance Inflation Factor}

Variance inflation factors measure the inflation in the variances of the parameter estimates due to 
collinearities that exist among the predictors. It is a measure of how much the variance of the estimated 
regression coefficient \eqn{\beta_k}  is inflated by the existence of correlation among the predictor variables 
in the model. A VIF of 1 means that there is no correlation among the kth predictor and the remaining predictor 
variables, and hence the variance of \eqn{\beta_k} is not inflated at all. The general rule of thumb is that VIFs 
exceeding 4 warrant further investigation, while VIFs exceeding 10 are signs of serious multicollinearity 
requiring correction.

Steps to calculate VIF:

\itemize{
  \item Regress the kth predictor on rest of the predictors in the model.
  \item Compute \eqn{R^2} - the coefficient of determination from the regression in the above step.
  \item \eqn{Tolerance = 1 / 1 - R^2 = 1 / Tolerance}
}

\emph{Condition Index}

Most multivariate statistical approaches involve decomposing a correlation matrix into linear 
combinations of variables. The linear combinations are chosen so that the first combination has 
the largest possible variance (subject to some restrictions), the second combination 
has the next largest variance, subject to being uncorrelated with the first, the third has the largest 
possible variance, subject to being uncorrelated with the first and second, and so forth. The variance 
of each of these linear combinations is called an eigenvalue. Collinearity is spotted by finding 2 or 
more variables that have large proportions of variance (.50 or more) that correspond to large condition 
indices. A rule of thumb is to label as large those condition indices in the range of 30 or larger.
}
\examples{
# model
model <- lm(mpg ~ disp + hp + wt + drat, data = mtcars)

# vif and tolerance
ols_vif_tol(model)

# eigenvalues and condition indices
ols_eigen_cindex(model)

# collinearity diagnostics
ols_coll_diag(model)

}
\references{
Belsley, D. A., Kuh, E., and Welsch, R. E. (1980). Regression Diagnostics: Identifying Influential Data and
Sources of Collinearity. New York: John Wiley & Sons.
}

