% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-pure-error-anova.R
\name{ols_pure_error_anova}
\alias{ols_pure_error_anova}
\title{Lack of Fit F Test}
\usage{
ols_pure_error_anova(model, ...)
}
\arguments{
\item{model}{an object of class \code{lm}}

\item{...}{other parameters}
}
\value{
\code{ols_pure_error_anova} returns an object of class
\code{"ols_pure_error_anova"}. An object of class \code{"ols_pure_error_anova"} is a
list containing the following components:

\item{lackoffit}{f statistic}
\item{pure_error}{pure error}
\item{rss}{regression sum of squares}
\item{ess}{error sum of squares}
\item{total}{total sum of squares}
\item{rms}{}
\item{ems}{p-value of \code{fstat}}
\item{lms}{degrees of freedom}
\item{pms}{name(s) of \code{variable}}
\item{rf}{name of \code{group_var}}
\item{lf}{f statistic}
\item{pr}{p-value of \code{fstat}}
\item{pl}{degrees of freedom}
\item{mpred}{name(s) of \code{variable}}
\item{df_rss}{name of \code{group_var}}
\item{df_ess}{f statistic}
\item{df_lof}{p-value of \code{fstat}}
\item{df_error}{degrees of freedom}
\item{final}{name(s) of \code{variable}}
\item{resp}{name of \code{group_var}}
\item{preds}{name of \code{group_var}}
}
\description{
Assess how much of the error in prediction is due to lack of model fit.
}
\details{
The residual sum of squares resulting from a regression can be decomposed into 2 components:

\itemize{
  \item Due to lack of fit
  \item Due to random variation
}

If most of the error is due to lack of fit and not just random error, the model should be discarded and
a new model must be built.
}
\note{
The lack of fit F test works only with simple linear regression. Moreover, it is important that the 
data contains repeat observations i.e. replicates for at least one of the values of the predictor x. This 
test generally only applies to datasets with plenty of replicates.
}
\examples{
model <- lm(mpg ~ disp, data = mtcars)
ols_pure_error_anova(model)
}
\references{
Kutner, MH, Nachtscheim CJ, Neter J and Li W., 2004, Applied Linear Statistical Models (5th edition). 
Chicago, IL., McGraw Hill/Irwin.
}

