% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-influence-measures.R
\name{ols_leverage}
\alias{ols_leverage}
\title{Leverage}
\usage{
ols_leverage(model)
}
\arguments{
\item{model}{an object of class \code{lm}}
}
\value{
leverage
}
\description{
The leverage of an observation is based on how much the observation's value on the predictor variable 
differs from the mean of the predictor variable. The greater an observation's leverage, the more potential it has 
to be an influential observation.
}
\examples{
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_leverage(model)
}
\references{
Kutner, MH, Nachtscheim CJ, Neter J and Li W., 2004, Applied Linear Statistical Models (5th edition). 
Chicago, IL., McGraw Hill/Irwin.
}
