% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naOmitMulti.r
\name{naOmitMulti}
\alias{naOmitMulti}
\title{Remove NAs from one or more equal-length vectors}
\usage{
naOmitMulti(...)
}
\arguments{
\item{...}{Numeric or character vectors.}
}
\value{
List of objects of class \code{...}.
}
\description{
This function removes elements in one or more equal-length vectors in which there is one \code{NA} at that position. For example, if there are three vectors \code{A}, \code{B}, and \code{C}, and \code{A} has an \code{NA} in the first position and \code{C} has an \code{NA} in the third position, then \code{A}, \code{B}, and \code{C} will each have the elements at positions 1 and 3 removed.
}
\examples{
a <- c(NA, 'b', 'c', 'd', 'e', NA)
b <- c(1, 2, 3, NA, 5, NA)
c <- c(6, 7, 8, 9, 10, NA)
naOmitMulti(a, b, c)
}
\seealso{
\code{\link[stats]{na.omit}}
}
