% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classCdmReference.R
\name{print.cdm_reference}
\alias{print.cdm_reference}
\title{Print a CDM reference object}
\usage{
\method{print}{cdm_reference}(x, ...)
}
\arguments{
\item{x}{A cdm_reference object}

\item{...}{Included for compatibility with generic. Not used.}
}
\value{
Invisibly returns the input
}
\description{
Print a CDM reference object
}
\examples{
\donttest{
library(omopgenerics)

cdm <- cdmFromTables(
  tables = list(
    "person" = dplyr::tibble(
      person_id = c(1, 2, 3), gender_concept_id = 0, year_of_birth = 1990,
      race_concept_id = 0, ethnicity_concept_id = 0
    ),
    "observation_period" = dplyr::tibble(
      observation_period_id = 1:3, person_id = 1:3,
      observation_period_start_date = as.Date("2000-01-01"),
      observation_period_end_date = as.Date("2025-12-31"),
      period_type_concept_id = 0
    )
  ),
  cdmName = "mock"
)

print(cdm)
}
}
