% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validateCohortArgument}
\alias{validateCohortArgument}
\title{Validate a cohort table input.}
\usage{
validateCohortArgument(
  cohort,
  checkEndAfterStart = FALSE,
  checkOverlappingEntries = FALSE,
  checkMissingValues = FALSE,
  checkInObservation = FALSE,
  checkAttributes = FALSE,
  checkPermanentTable = FALSE,
  dropExtraColumns = FALSE,
  validation = "error",
  call = parent.frame()
)
}
\arguments{
\item{cohort}{Object to be validated as a valid cohort input.}

\item{checkEndAfterStart}{If TRUE a check that all cohort end dates come on
or after cohort start date will be performed.}

\item{checkOverlappingEntries}{If TRUE a check that no individuals have
overlapping cohort entries will be performed.}

\item{checkMissingValues}{If TRUE a check that there are no missing values in
required fields will be performed.}

\item{checkInObservation}{If TRUE a check that cohort entries are within
the individuals observation periods will be performed.}

\item{checkAttributes}{Whether to check if attributes are present and
populated correctly.}

\item{checkPermanentTable}{Whether to check if the table has to be a
permanent table.}

\item{dropExtraColumns}{Whether to drop extra columns that are not the
required ones.}

\item{validation}{How to perform validation: "error", "warning".}

\item{call}{A call argument to pass to cli functions.}
}
\description{
Validate a cohort table input.
}
\examples{
cdm <- cdmFromTables(
  tables = list(
    "person" = dplyr::tibble(
      person_id = c(1, 2, 3), gender_concept_id = 0, year_of_birth = 1990,
      race_concept_id = 0, ethnicity_concept_id = 0
    ),
    "observation_period" = dplyr::tibble(
      observation_period_id = 1:3, person_id = 1:3,
      observation_period_start_date = as.Date("2000-01-01"),
      observation_period_end_date = as.Date("2023-12-31"),
      period_type_concept_id = 0
    )
   ),
   cohortTables = list(
    cohort = dplyr::tibble(
      cohort_definition_id = 1L,
      subject_id = 1L,
      cohort_start_date = as.Date("2020-01-01"),
      cohort_end_date = as.Date("2021-02-10")
    )
  ),
  cdmName = "mock"
)

validateCohortArgument(cdm$cohort)

}
