% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fph.R
\name{fph}
\alias{fph}
\title{Fetch PowerPoint Placeholder}
\usage{
fph(obnd, template = NULL, pn = NULL, verbose = TRUE)
}
\arguments{
\item{obnd}{onbrand report object}

\item{template}{Name of slide template (name from templates in yaml mapping file)}

\item{pn}{Placehodler name to fetch}

\item{verbose}{Boolean variable when set to TRUE (default) messages will be
displayed on the terminal; Messages will be included in the returned list.}
}
\value{
List with the following elements
\itemize{
\item{ph}:      Placeholder label or \code{NULL} if failure
\item{type}:    Placeholder content type in PowerPoint or \code{NULL} if failure
\item{isgood}: Boolean variable indicating success or failure
\item{msgs}: Vector of messages
}
}
\description{
Retrieves the placeholder name in PowerPoint for a specified
layout element.
}
\examples{
# Creating an onbrand object:
obnd = read_template(
      template = file.path(system.file(package="onbrand"), "templates", "report.pptx"),
      mapping  = file.path(system.file(package="onbrand"), "templates", "report.yaml"))

# Pulling out the placeholder information:
ph = fph(obnd, "two_content_header_text", "content_left_header")


}
