% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/template_details.R
\name{template_details}
\alias{template_details}
\title{Show Template Details for `onbrand` Object}
\usage{
template_details(obnd, verbose = TRUE)
}
\arguments{
\item{obnd}{onbrand report object}

\item{verbose}{Boolean variable when set to TRUE (default) messages will be
displayed on the terminal; Messages will be included in the returned results
object.}
}
\value{
list with the following elements:
\itemize{
 \item{rpttype}:      Type of report (either PowerPoint or Word)
 \item{msgs}:         Vector of messages with details or any errors that were encountered
 \item{txt}:          Vector of template details in text format
 \item{df}:           Vector of template details in a dataframe
 \item{ft}:           Vector of template details in flextable format
 \item{isgood}:       Boolean variable indicating the current state of the object
}
}
\description{
Takes an onbrand object with a loaded template and displays
relevant details about the template.
}
\details{
Provides relevant details about an onbrand object.  For PowerPoint 
this contains the template names and elements present for that template. For 
Word it will contain defined text and table styles. This information can be 
displayed in the console, returned as text or formatted for use in RMarkdown 
documentation.
}
\examples{
obnd = read_template(
   template = file.path(system.file(package="onbrand"), "templates", "report.pptx"),
   mapping  = file.path(system.file(package="onbrand"), "templates", "report.yaml"))
details = template_details(obnd)

obnd = read_template(
   template = file.path(system.file(package="onbrand"), "templates", "report.docx"),
   mapping  = file.path(system.file(package="onbrand"), "templates", "report.yaml"))
details = template_details(obnd)
}
