% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CALCPHENOTYPE.R
\name{calcPhenotype}
\alias{calcPhenotype}
\title{Generate predicted drug sensitivity scores}
\usage{
calcPhenotype(
  trainingExprData,
  trainingPtype,
  testExprData,
  batchCorrect,
  powerTransformPhenotype = TRUE,
  removeLowVaryingGenes = 0.2,
  minNumSamples,
  selection = 1,
  printOutput,
  pcr = FALSE,
  removeLowVaringGenesFrom,
  report_pc = FALSE,
  cc = FALSE,
  percent = 80,
  rsq = FALSE,
  folder = TRUE
)
}
\arguments{
\item{trainingExprData}{The training data. A matrix of expression levels. rownames() are genes, colnames() are samples (cell line names or cosmic ides, etc.). rownames() must be specified and must contain the same type of gene ids as "testExprData"}

\item{trainingPtype}{The known phenotype for "trainingExprData". This data must be a matrix of drugs/rows x cell lines/columns or cosmic ids/columns. This matrix can contain NA values, that is ok (they are removed in the calcPhenotype() function).}

\item{testExprData}{The test data where the phenotype will be estimated. It is a matrix of expression levels, rows contain genes and columns contain samples, "rownames()" must be specified and must contain the same type of gene ids as "trainingExprData".}

\item{batchCorrect}{How should training and test data matrices be homogenized. Choices are "eb" (default) for ComBat, "qn" for quantiles normalization or "none" for no homogenization.}

\item{powerTransformPhenotype}{Should the phenotype be power transformed before we fit the regression model? Default to TRUE, set to FALSE if the phenotype is already known to be highly normal.}

\item{removeLowVaryingGenes}{What proportion of low varying genes should be removed? 20 percent be default}

\item{minNumSamples}{How many training and test samples are required. Print an error if below this threshold}

\item{selection}{How should duplicate gene ids be handled. Default is -1 which asks the user. 1 to summarize by their or 2 to disguard all duplicates.}

\item{printOutput}{Set to FALSE to supress output.}

\item{pcr}{Indicates whether or not you'd like to use pcr for feature (gene) reduction. Options are 'TRUE' and 'FALSE'. If you indicate 'report_pc=TRUE' you need to also indicate 'pcr=TRUE'}

\item{removeLowVaringGenesFrom}{Determine method to remove low varying genes. Options are 'homogenizeData' and 'rawData'.}

\item{report_pc}{Indicates whether you want to output the training principal components. Options are 'TRUE' and 'FALSE'. Folder must be set to TRUE.}

\item{cc}{Indicate if you want correlation coefficients for biomarker discovery. folder must be set to TRUE}

\item{percent}{Indicate percent variability (of the training data) you'd like principal components to reflect if pcr=TRUE. Default is 80 for 80\%
These are the correlations between a given gene of interest across all samples vs. a given drug response across samples.
These correlations can be ranked to obtain a ranked correlation to determine highly correlated drug-gene associations.}

\item{rsq}{Indicate whether or not you want to output the R^2 values for the data you train on from true and predicted values.
These values represent the percentage in which the optimal model accounts for the variance in the training data.
Options are 'TRUE' and 'FALSE'. folder must be set to TRUE}

\item{folder}{Indicate whether the user wants to return a folder or simply assign the calcPhenotype output. If true, run the function without assignment as it will return a folder with the results. If false, assign <- calcphenotype to save results}
}
\value{
Depends on the folder parameter. If folder = True, .txt files will be saved into a folder in your working directory automatically. The folder will include the estimated drug response values as a .txt file. Depending on the rsq, cc, report_pc parameters specified, the .txt file outputs of this function will also include
the R^2 data, and the correlation coefficients and principal components are stored as .RData files for each drug in your drug dataset.
If folder = 'FALSE', then only the predicted drug response values will be returned as an object.
}
\description{
This function predicts a phenotype (drug sensitivity score) when provided with microarray or bulk RNAseq gene expression data of different platforms.
The imputations are performed using ridge regression, training on a gene expression matrix where phenotype is already known.
This function integrates training and testing datasets via a user-defined procedure, and power transforming the known phenotype.
}
\keyword{and}
\keyword{drug}
\keyword{phenotype}
\keyword{predict}
\keyword{sensitivity}
