\name{ug}
\alias{ug}
\title{Unidirectional Growth}
\description{
  Implements the marker ordering algorithm \emph{Unidirectional Growth}
  (\cite{Tan & Fu, 2006}).
}
\usage{
ug(input.seq, LOD=0, max.rf=0.5)
}
\arguments{
  \item{input.seq}{an object of class \code{sequence}.}
  \item{LOD}{minimum LOD-Score threshold used when constructing the
    pairwise recombination fraction matrix.}
  \item{max.rf}{maximum recombination fraction threshold used as the LOD
    value above.}
}
\details{
  \emph{Unidirectional Growth} (\emph{UG}) is an algorithm for marker
  ordering in linkage groups. It is not an exhaustive search method and,
  therefore, is not computationally intensive. However, it does not
  guarantee that the best order is always found. The only requirement is
  a matrix with recombination fractions between markers. Next is an
  adapted excerpt from \cite{Mollinari et al (2009)} describing the
  \emph{UG} algorithm:
  
  \emph{Based on the \eqn{R} (recombination fraction) matrix, the
    distance between all \eqn{m} loci is calculated by \eqn{d_{ij} =
      \hat{r}_{ij} + (\frac{2}{n_{ij}}) \sum_{k} \hat{r}_{ik}
      \hat{r}_{jk}}{d_ij = r_ij + (2/n_ij) Sum_k r_ik r_jk}, for every
    \eqn{k}, with \eqn{\hat{r}_{ij} > \hat{r}_{ik}, \hat{r}_{ij} >
    \hat{r}_{jk}}{r_ij > r_ik, r_ij > r_jk}, and \eqn{n_{ij}}{n_ij}
    individuals. The value \eqn{T_{ij} = 2 d_{ij} - (\sum_{k \neq i}
    d_{ik} + \sum_{k \neq j} d_{jk})}{T_ij = 2 d_ij - (Sum_{k != i}
    d_ik + Sum_{k != j} d_jk)} is calculated for every \eqn{i < j}. The
    terminal end of the map is defined by taking the pair of markers
    \eqn{(f, g)} that presents the smallest value of \eqn{T}. The pair
    \eqn{(f, g)} is then denoted locus \eqn{m + 1} and its distance to
    the remaining markers is determined by \eqn{d_{i m+1} = \frac{1}{2}(d_{if} +
    d_{ig} - d_{fg})}{d_im+1 = (1/2)(d_if + d_ig - d_fg)} if \eqn{(d_{if} +
    d_{ig}) > d_{fg}}{(d_if + d_ig) > d_fg}, if not, \eqn{d_{i m+1} =
    0}{d_im+1 = 0}. The calculation \eqn{W_{i m+1} = (m - 2) d_{i m+1} -
    \sum_{k \neq i} d_{ik}}{W_im+1 = (m-2) d_im+1 - Sum_{k != i} d_ik}
    is also performed and the locus that minimizes the value \eqn{W_{i
    m+1}}{W_im+1} (called locus \eqn{h}) is placed on the map. The
    partial resultant map is \emph{f-g-h} if \eqn{d_{fh} > d_{gh}}{d_fh
    > d_gh} or \emph{h-f-g} otherwise. Considering \eqn{k = 2}, the
    partial distance of the map with the remaining markers is updated:
    \eqn{d_{i m+k} = \mbox{min}(d_{i m+k-1}, d_{ij})}{d_im+k =
    min(d_im+k-1, d_ij)}. The value \eqn{W_{i m+k} = (m - k - 1) d_{i
    m+k} - \sum_{k \neq i} d_{ik}}{W_im+k = (m-k-1) d_im+k - Sum_{k !=
    i} d_ik} is calculated and the locus that minimizes \eqn{W} is added
    to the map. The last two steps are repeated, taking \eqn{k = 3,
    \ldots, m - 1}{k = 3, ..., m-1} to obtain the complete map.}
  
  After determining the order with \emph{UG}, the final map is constructed
  using the multipoint approach (function \code{\link[onemap]{map}}).
}
\value{
  An object of class \code{sequence}, which is a list containing the
  following components:
  \item{seq.num}{a \code{vector} containing the (ordered) indices of
    markers in the sequence, according to the input file.}
  \item{seq.phases}{a \code{vector} with the linkage phases between markers
    in the sequence, in corresponding positions. \code{-1} means taht there are
    no defined linkage phases.}
  \item{seq.rf}{a \code{vector} with the recombination frequencies between
    markers in the sequence. \code{-1} means that there are no estimated
    recombination frequencies.}
  \item{seq.like}{log-likelihood of the corresponding linkage map.}
  \item{data.name}{name of the object of class \code{outcross} with the
    raw data.}
  \item{twopt}{name of the object of class \code{rf.2pts} with the 2-point
    analyses.}
}
\references{
  Mollinari, M., Margarido, G. R. A., Vencovsky, R. and Garcia,
  A. A. F. (2009) Evaluation of algorithms used to order markers on
  genetics maps. \emph{Heredity} 103: 494-502.

  Tan, Y. and Fu, Y. (2006) A novel method for estimating linkage
  maps. \emph{Genetics} 173: 2383-2390.
}
\author{Marcelo Mollinari, \email{mmollina@esalq.usp.br}}
\seealso{
  \code{\link[onemap]{make.seq}}, \code{\link[onemap]{map}}
}
\examples{
  #outcross example
  data(example.out)
  twopt <- rf.2pts(example.out)
  all.mark <- make.seq(twopt,"all")
  groups <- group(all.mark)
  LG1 <- make.seq(groups,1)
  LG1.ug <- ug(LG1)

  #F2 example
  data(fake.f2.onemap)
  twopt <- rf.2pts(fake.f2.onemap)
  all.mark <- make.seq(twopt,"all")
  groups <- group(all.mark)
  LG1 <- make.seq(groups,1)
  LG1.ug <- ug(LG1)
  LG1.ug
}
\keyword{utilities}
