% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{filter_2pts_gaps}
\alias{filter_2pts_gaps}
\title{Filter markers based on 2pts distance}
\usage{
filter_2pts_gaps(input.seq, max.gap = 10)
}
\arguments{
\item{input.seq}{object of class sequence with ordered markers}

\item{max.gap}{maximum gap measured in kosambi centimorgans allowed between adjacent markers. 
Markers that presents the defined distance between both adjacent neighbors will be removed.}
}
\value{
New sequence object of class \code{sequence}, which is a list containing the
following components: \item{seq.num}{a \code{vector} containing the
(ordered) indices of markers in the sequence, according to the input file.}
\item{seq.phases}{a \code{vector} with the linkage phases between markers
in the sequence, in corresponding positions. \code{-1} means that there are
no defined linkage phases.} \item{seq.rf}{a \code{vector} with the
recombination frequencies between markers in the sequence. \code{-1} means
that there are no estimated recombination frequencies.}
\item{seq.like}{log-likelihood of the corresponding linkage map.}
\item{data.name}{object of class \code{onemap} with the raw
data.} \item{twopt}{object of class \code{rf_2pts} with the
2-point analyses.}
}
\description{
Filter markers based on 2pts distance
}
\author{
Cristiane Taniguti, \email{chtaniguti@tamu.edu}
}
