% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seeded_map.R
\name{seeded_map}
\alias{seeded_map}
\title{Construct the linkage map for a sequence of markers after seeding phases}
\usage{
seeded_map(
  input.seq,
  tol = 1e-04,
  phase_cores = 1,
  seeds,
  verbose = FALSE,
  rm_unlinked = FALSE,
  parallelization.type = "PSOCK"
)
}
\arguments{
\item{input.seq}{an object of class \code{sequence}.}

\item{tol}{tolerance for the C routine, i.e., the value used to evaluate
convergence.}

\item{phase_cores}{The number of parallel processes to use when estimating
the phase of a marker. (Should be no more than 4)}

\item{seeds}{A vector given the integer encoding of phases for the first
\emph{N} positions of the map}

\item{verbose}{A logical, if TRUE it output progress status
information.}

\item{rm_unlinked}{When some pair of markers do not follow the linkage criteria, 
if \code{TRUE} one of the markers is removed and map is performed again.}

\item{parallelization.type}{one of the supported cluster types. This should 
be either PSOCK (default) or FORK.}
}
\value{
An object of class \code{sequence}, which is a list containing the
following components: \item{seq.num}{a \code{vector} containing the
(ordered) indices of markers in the sequence, according to the input file.}
\item{seq.phases}{a \code{vector} with the linkage phases between markers
in the sequence, in corresponding positions. \code{-1} means that there are
no defined linkage phases.} \item{seq.rf}{a \code{vector} with the
recombination frequencies between markers in the sequence. \code{-1} means
that there are no estimated recombination frequencies.}
\item{seq.like}{log-likelihood of the corresponding linkage map.}
\item{data.name}{name of the object of class \code{outcross} with the raw
data.} \item{twopt}{name of the object of class \code{rf_2pts} with the
2-point analyses.}
}
\description{
Estimates the multipoint log-likelihood, linkage phases and recombination
frequencies for a sequence of markers in a given order using seeded phases.
}
\details{
Markers are mapped in the order defined in the object \code{input.seq}. The
best combination of linkage phases is also estimated starting from the first
position not in the given seeds.The multipoint likelihood is calculated
according to Wu et al. (2002b)(Eqs. 7a to 11), assuming that the
recombination fraction is the same in both parents. Hidden Markov chain
codes adapted from Broman et al. (2008) were used.
}
\examples{
\donttest{
  data(onemap_example_out)
  twopt <- rf_2pts(onemap_example_out)

  markers <- make_seq(twopt,c(30,12,3,14,2))
  seeded_map(markers, seeds = c(4,2))
}
}
\references{
Broman, K. W., Wu, H., Churchill, G., Sen, S., Yandell, B.
(2008) \emph{qtl: Tools for analyzing QTL experiments} R package version
1.09-43

Jiang, C. and Zeng, Z.-B. (1997). Mapping quantitative trait loci with
dominant and missing markers in various crosses from two inbred lines.
\emph{Genetica} 101: 47-58.

Lander, E. S., Green, P., Abrahamson, J., Barlow, A., Daly, M. J., Lincoln,
S. E. and Newburg, L. (1987) MAPMAKER: An interactive computer package for
constructing primary genetic linkage maps of experimental and natural
populations. \emph{Genomics} 1: 174-181.

Wu, R., Ma, C.-X., Painter, I. and Zeng, Z.-B. (2002a) Simultaneous maximum
likelihood estimation of linkage and linkage phases in outcrossing species.
\emph{Theoretical Population Biology} 61: 349-363.

Wu, R., Ma, C.-X., Wu, S. S. and Zeng, Z.-B. (2002b). Linkage mapping of
sex-specific differences. \emph{Genetical Research} 79: 85-96
}
\seealso{
\code{\link[onemap]{make_seq}}
}
\author{
Adapted from Karl Broman (package 'qtl') by Gabriel R A Margarido,
\email{gramarga@usp.br} and Marcelo Mollinari, \email{mmollina@gmail.com}.
Modified to use seeded phases by Bastian Schiffthaler
\email{bastian.schiffthaler@umu.se}
}
\keyword{utilities}
