% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_onemap.R
\name{read_onemap}
\alias{read_onemap}
\title{Read data from all types of progenies supported by OneMap}
\usage{
read_onemap(inputfile = NULL, dir = NULL, verbose = TRUE)
}
\arguments{
\item{inputfile}{the name of the input file which contains the data to be read.}

\item{dir}{directory where the input file is located.}

\item{verbose}{A logical, if TRUE it output progress status
information.}
}
\value{
An object of class \code{onemap}, i.e., a list with the following
components: \item{geno}{a matrix with integers indicating the genotypes
read for each marker. Each column contains data for a marker and each row
represents an individual.} \item{n.ind}{number of individuals.}
\item{n.mar}{number of markers.} \item{segr.type}{a vector with the
segregation type of each marker, as \code{strings}.} \item{segr.type.num}{a
vector with the segregation type of each marker, represented in a
simplified manner as integers, i.e. 1 corresponds to markers of type
\code{"A"}; 2 corresponds to markers of type \code{"B1.5"}; 3 corresponds
to markers of type \code{"B2.6"}; 4 corresponds to markers of type
\code{"B3.7"}; 5 corresponds to markers of type \code{"C.8"}; 6 corresponds
to markers of type \code{"D1"} and 7 corresponds to markers of type
\code{"D2"}. Markers for F2 intercrosses are coded as 1; all other crosses
are left as \code{NA}.} \item{input}{the name of the input file.}
\item{n.phe}{number of phenotypes.} \item{pheno}{a matrix with phenotypic
values. Each column contains data for a trait and each row represents an
individual.} \item{error}{matrix containing HMM emission probabilities}
}
\description{
Imports data derived from outbred parents (full-sib family) or inbred
parents (backcross, F2 intercross and recombinant inbred lines obtained
by self- or sib-mating). Creates an object of class \code{onemap}.
}
\details{
The file format is similar to that used by \code{MAPMAKER/EXP}
(\cite{Lincoln et al.}, 1993). The first line indicates the cross type
and is structured as \code{data type \{cross\}}, where \code{cross}
must be one of \code{"outcross"}, \code{"f2 intercross"},
\code{"f2 backcross"}, \code{"ri self"} or  \code{"ri sib"}. The second line
contains five integers: i) the number of individuals; ii) the number of
markers; iii) an indicator variable taking the value 1 if there is CHROM
information, i.e., if markers are anchored on any reference sequence, and
0 otherwise; iv) a similar 1/0 variable indicating whether there is POS
information for markers; and v) the number of phenotypic traits.

The next line contains sample IDs, separated by empty spaces or tabs.
Addition of this sample ID requirement makes it possible for separate input
datasets to be merged.

Next comes the genotype data for all markers. Each new marker is initiated
with a \dQuote{*} (without the quotes) followed by the marker name, without
any space between them. Each marker name is followed by the corresponding
segregation type, which may be: \code{"A.1"}, \code{"A.2"}, \code{"A.3"},
\code{"A.4"}, \code{"B1.5"}, \code{"B2.6"}, \code{"B3.7"}, \code{"C.8"},
\code{"D1.9"}, \code{"D1.10"}, \code{"D1.11"}, \code{"D1.12"},
\code{"D1.13"}, \code{"D2.14"}, \code{"D2.15"}, \code{"D2.16"},
\code{"D2.17"} or \code{"D2.18"} (without quotes), for full-sibs [see
\code{\link[onemap]{marker_type}} and \cite{Wu et al.} (2002) for details].
Other cross types have special marker types: \code{"A.H"} for backcrosses;
\code{"A.H.B"} for F2 intercrosses; and \code{"A.B"} for recombinant inbred
lines.

After the segregation type comes the genotype data for the
corresponding marker. Depending on the segregation type, genotypes may be
denoted by \code{ac}, \code{ad}, \code{bc}, \code{bd}, \code{a}, \code{ba},
\code{b}, \code{bc}, \code{ab} and \code{o}, in several possible
combinations. To make things easier, we have followed \strong{exactly} the
notation used by \cite{Wu et al.} (2002). Allowed values for backcrosses
are \code{a} and \code{ab}; for F2 crosses they are \code{a}, \code{ab} and
\code{b}; for RILs they may be \code{a} and \code{b}. Genotypes \emph{must}
be separated by a space. Missing values are denoted by \code{"-"}.

If there is physical information for markers, i.e., if they are anchored at
specific positions in reference sequences (usually chromosomes), this is
included immediately after the marker data. These lines start with special
keywords \code{*CHROM} and \code{*POS} and contain \code{strings} and
\code{integers}, respectively, indicating the reference sequence and
position for each marker. These also need to be separated by spaces.

Finally, if there is phenotypic data, it will be added just after the marker
or \code{CHROM}/\code{POS} data. They need to be separated by spaces as
well, using the same symbol for missing information.

The \code{example} directory in the package distribution contains an
example data file to be read with this function. Further instructions can
be found at the tutorial distributed along with this package.
}
\examples{
\donttest{
 outcr_data <- read_onemap(inputfile= 
 system.file("extdata/onemap_example_out.raw", package= "onemap"))
}
}
\references{
Lincoln, S. E., Daly, M. J. and Lander, E. S. (1993)
Constructing genetic linkage maps with MAPMAKER/EXP Version 3.0: a tutorial
and reference manual. \emph{A Whitehead Institute for Biomedical Research
Technical Report}.

Wu, R., Ma, C.-X., Painter, I. and Zeng, Z.-B. (2002) Simultaneous maximum
likelihood estimation of linkage and linkage phases in outcrossing species.
\emph{Theoretical Population Biology} 61: 349-363.
}
\seealso{
\code{\link[onemap]{combine_onemap}} and the \code{example}
directory in the package source.
}
\author{
Gabriel R A Margarido, \email{gramarga@gmail.com}
}
\keyword{IO}
