## ---- message=FALSE, results="hide"-------------------------------------------
# Run the default selection, which is "both" and equivalent to "backwadboth"
# Note the control argument, which is passed to optim, it's now set to few
# iterations in the prm optimization
Lboth <- step_optim(model, D, prm, direction="both", control=list(maxit=1), mc.cores=1)

## ---- message=FALSE, results="hide"-------------------------------------------
Lforward <- step_optim(model, D, prm, "forward", control=list(maxit=1), mc.cores=1)

## ---- message=FALSE, results="hide"-------------------------------------------
Lbackward <- step_optim(model, D, prm, "backward", control=list(maxit=1), mc.cores=1)

## ---- message=FALSE, results="hide"-------------------------------------------
# Clone the model to make a starting model
modelstart <- model$clone_deep()
# Remove two inputs
modelstart$inputs[2:3] <- NULL
# Run the selection
L <- step_optim(model, D, prm, modelstart=modelstart, control=list(maxit=1), mc.cores=1)

