% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlabel_local.R
\name{rlabel_local}
\alias{rlabel_local}
\title{rlabel_local}
\usage{
rlabel_local(X, distance, nsim = 19, drop = TRUE)
}
\arguments{
\item{X}{ppp}

\item{distance}{Mark of points that do not change.}

\item{nsim}{Number of patterns to simulate.}

\item{drop}{If nsim = 1 and drop = TRUE , the result will be a point pattern,
rather than a list containing a point pattern.}
}
\value{
list
}
\description{
Local random labelling of marked point pattern
}
\details{
Local random labelling function, i.e. marks will be shuffeld only across points
within the specified local distance. Technically, this is achived by sampling the
mark of a neighbouring point j within the distance d for the focal point i. Thus,
the distance d must be selected in a way that each point has at least one neighbour
within d.

Returns a \code{list} with \code{ppp} objects.
}
\examples{
set.seed(42)
pattern <- spatstat.random::runifpoint(n = 250, win = spatstat.geom::owin(c(0, 100), c(0, 100)))
spatstat.geom::marks(pattern) <- runif(n = 250, min = 10, max = 120)

rlabel_local(X = pattern, distance = 25, nsim = 19)

}
\references{
Velázquez, E., Martínez, I., Getzin, S., Moloney, K.A., Wiegand, T., 2016. An evaluation
of the state of spatial point pattern analysis in ecology. Ecography 39, 1–14.
<https://doi.org/10.1111/ecog.01579>

Wiegand, T., Moloney, K.A., 2014. Handbook of spatial point-pattern analysis in
ecology. Chapman and Hall/CRC Press, Boca Raton, USA. <isbn:978-1-4200-8254-8>
}
\seealso{
\code{\link{rlabel}}
}
