% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_stratified_sim_p_sorted}
\alias{get_stratified_sim_p_sorted}
\title{Get stratified similarity p-value (sorted)}
\usage{
get_stratified_sim_p_sorted(sorted_sym_sim_mat, row_strata_factor, case_group,
  min_its = 1000, max_its = 1e+06, signif = 0.05, log_dismiss = -15,
  subgroup_size = NULL)
}
\arguments{
\item{sorted_sym_sim_mat}{Symmetric numeric term set similarity matrix with rows sorted by strata}

\item{row_strata_factor}{Factor of strata to which the rows of the similarity matrix belong}

\item{case_group}{Character or integer vector of cases specifying rownames/indices of cases for which to calculate a similarity p-value.}

\item{min_its}{Minimum number of simulated group similarities to calculate}

\item{max_its}{Maximum number of simulated group similarities to calculate}

\item{signif}{Threshold p-value of statistical significance}

\item{log_dismiss}{Threshold of log probability, below which to trigger return of current estimated p-value}

\item{subgroup_size}{Calculate significance of similarity of most similar subgroup within \code{case_group}. Set to NULL to use the whole group (default).}
}
\value{
Numeric p-value of similarity computed from null distribution (group similarity of all groups containing the same number of cases from each strata)
}
\description{
Get stratified similarity p-value (sorted)
}

