% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alter.R
\name{change_formals}
\alias{change_formals}
\title{Change the Formal Arguments of a oClass Generator}
\usage{
change_formals(x, ..., envir = parent.frame(), from_init = NULL)
}
\arguments{
\item{x}{oClass generator function}

\item{...}{named or unnamed objects used as the formal arguments of the generator function}

\item{envir}{environment from which to evaluate arguments}

\item{from_init}{function containing the formal arguments to use; typically an \code{\link{init}} function. \code{...} and \code{envir} are ignored if not \code{NULL}.}
}
\value{
oClass generator function
}
\description{
This accepts an \code{\link{oClass}} generator and updates its formal arguments based either on those
passed in \code{...} or the function passed to \code{from_init}. The results will be
passed to the appropriate \code{\link{init}} function each time an instance is generated.
}
\examples{
clown <- oClass("clown")
clown

# 'init' requires a laugh
init.clown <- function(x, laugh, ...){
  x$laugh <- laugh
  add_fields(x, ...)
  return(x)
}

# change formals of clown
clown <- change_formals(clown, from_init = init.clown)

# alternatively,
clown <- change_formals(clown, laugh, ..dots)

# creation
happy_clown <- clown("HAHA")
sad_clown   <- clown("ha")

}
