% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.file.r
\name{opal.file_read}
\alias{opal.file_read}
\title{Read a file}
\usage{
opal.file_read(opal, source, destination)
}
\arguments{
\item{opal}{Opal object.}

\item{source}{Path to the file in the R session workspace (must exists).}

\item{destination}{Path to the destination file or folder. Any required sub-folders will be created.}
}
\description{
Read a file from the R session workspace into the Opal file system.
}
\examples{
\dontrun{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
# read into folder
opal.file_read(o,"DatabaseTest.sav", "/tmp")
# read and rename
opal.file_read(o,"test/DatabaseTest.sav", "/tmp/Test.sav")
# user home expansion
opal.file_read(o,"DatabaseTest.sav", "~/coucou/pwel.sav")
opal.logout(o)
}
}
\seealso{
Other file functions: 
\code{\link{opal.file_cp}()},
\code{\link{opal.file_download}()},
\code{\link{opal.file_ls}()},
\code{\link{opal.file_mkdir}()},
\code{\link{opal.file_mv}()},
\code{\link{opal.file_rm}()},
\code{\link{opal.file_upload}()},
\code{\link{opal.file_write}()},
\code{\link{opal.file}()}
}
\concept{file functions}
