% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.command.r
\name{opal.command_result}
\alias{opal.command_result}
\title{Get result of an asynchronous command}
\usage{
opal.command_result(opal, id, wait = FALSE)
}
\arguments{
\item{opal}{Opal object.}

\item{id}{R command ID.}

\item{wait}{Wait for the command to complete.}
}
\description{
Get the result of an asynchronous R commands in the remote R session. The command is removed from the
remote R session after this call.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.command_result(o, '1234')
opal.logout(o)
}
}
\seealso{
Other command functions: 
\code{\link{opal.command_rm}()},
\code{\link{opal.commands_rm}()},
\code{\link{opal.commands}()},
\code{\link{opal.command}()}
}
\concept{command functions}
