% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.resource.r
\name{opal.resources_perm}
\alias{opal.resources_perm}
\title{Get the permissions on any resource}
\usage{
opal.resources_perm(opal, project)
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{The project name.}
}
\value{
A data.frame with columns: subject, type, permission
}
\description{
Get the permissions that were applied globally on the project's resources.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.resources_perm_add(o, 'CNSIM', c('andrei', 'valentina'), 'user', 'view')
opal.resources_perm(o, 'CNSIM')
opal.resources_perm_delete(o, 'CNSIM', c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
