% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.R
\name{opal.put}
\alias{opal.put}
\title{Generic REST resource update.}
\usage{
opal.put(
  opal,
  ...,
  query = list(),
  body = "",
  contentType = "application/x-rscript",
  callback = NULL
)
}
\arguments{
\item{opal}{Opal object.}

\item{...}{Resource path segments.}

\item{query}{Named list of query parameters.}

\item{body}{The body of the request.}

\item{contentType}{The type of the body content.}

\item{callback}{A callback function to handle the response object.}
}
\description{
Generic REST resource update.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.put(o, 'some', 'resource', 'toupdate', body='{"some":"value"}')
opal.logout(o)
}
}
\seealso{
Other REST functions: 
\code{\link{opal.delete}()},
\code{\link{opal.get}()},
\code{\link{opal.post}()}
}
\concept{REST functions}
