% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_classFunctions.R
\name{plot.openEBGM}
\alias{plot.openEBGM}
\title{Plot an openEBGM object}
\usage{
\method{plot}{openEBGM}(x, y = NULL, event = NULL, plot.type = "bar", ...)
}
\arguments{
\item{x}{An openEBGM object constructed by \code{ebScores()}}

\item{y}{Unused parameter to satisfy generic function requirement}

\item{event}{An (optional) specification of an event to subset the data by.}

\item{plot.type}{A character vector specifying which type of plot should be
output. See details.}

\item{...}{Arguments to be passed to methods}
}
\description{
Plot an openEBGM object
}
\details{
There are three different types of plots that the plot function may
         produce when called on an openEBGM object. These are
         \itemize{
           \item bar
           \item shrinkage
           \item histogram
}

A bar chart displays the top ten product-symptom EBGM scores, as
  well as error bars which display the highest and lowest of the quantiles
  chosen at the time of instantiating the openEBGM object. A shrinkage plot
  plots EBGM score on the y axis, and the natural log of the RR on the x
  axis. This plot is also called a squid plot and was conceived by Stuart
  Chirtel. Finally, a histogram simply displays a histogram of the EBGM
  scores.
}
