/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref;

import java.io.IOException;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.DiscourseModel;
import opennlp.tools.coref.Linker;
import opennlp.tools.coref.LinkerMode;
import opennlp.tools.coref.mention.HeadFinder;
import opennlp.tools.coref.mention.Mention;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.mention.MentionFinder;
import opennlp.tools.coref.mention.Parse;
import opennlp.tools.coref.resolver.AbstractResolver;
import opennlp.tools.coref.sim.Gender;
import opennlp.tools.coref.sim.Number;

public abstract class AbstractLinker
implements Linker {
    protected MentionFinder mentionFinder;
    protected boolean debug = true;
    protected LinkerMode mode;
    protected static Linker linker;
    protected AbstractResolver[] resolvers;
    protected String[] resolverNames;
    protected DiscourseEntity[] entities;
    protected int SINGULAR_PRONOUN;
    protected String corefProject;
    protected HeadFinder headFinder;
    protected boolean useDiscourseModel;
    protected boolean removeUnresolvedMentions;

    public AbstractLinker(String project, LinkerMode mode) {
        this(project, mode, true);
    }

    public AbstractLinker(String project, LinkerMode mode, boolean useDiscourseModel) {
        this.corefProject = project;
        this.mode = mode;
        this.SINGULAR_PRONOUN = -1;
        this.useDiscourseModel = useDiscourseModel;
        this.removeUnresolvedMentions = true;
    }

    protected void resolve(MentionContext mention, DiscourseModel discourseModel) {
        boolean validEntity = true;
        boolean canResolve = false;
        for (int ri = 0; ri < this.resolvers.length; ++ri) {
            if (this.resolvers[ri].canResolve(mention)) {
                if (this.mode == LinkerMode.TEST) {
                    this.entities[ri] = this.resolvers[ri].resolve(mention, discourseModel);
                    canResolve = true;
                } else if (this.mode == LinkerMode.TRAIN) {
                    this.entities[ri] = this.resolvers[ri].retain(mention, discourseModel);
                    if (ri + 1 != this.resolvers.length) {
                        canResolve = true;
                    }
                } else if (this.mode == LinkerMode.EVAL) {
                    this.entities[ri] = this.resolvers[ri].retain(mention, discourseModel);
                } else {
                    System.err.println("AbstractLinker.Unknown mode: " + this.mode);
                }
                if (ri != this.SINGULAR_PRONOUN || this.entities[ri] != null) continue;
                validEntity = false;
                continue;
            }
            this.entities[ri] = null;
        }
        if (!canResolve && this.removeUnresolvedMentions) {
            validEntity = false;
        }
        DiscourseEntity de = this.checkForMerges(discourseModel, this.entities);
        if (validEntity) {
            this.updateExtent(discourseModel, mention, de, this.useDiscourseModel);
        }
    }

    public HeadFinder getHeadFinder() {
        return this.headFinder;
    }

    protected void updateExtent(DiscourseModel dm, MentionContext mention, DiscourseEntity entity, boolean useDiscourseModel) {
        if (useDiscourseModel) {
            if (entity != null) {
                if (entity.getGenderProbability() < mention.getGenderProb()) {
                    entity.setGender(mention.getGender());
                    entity.setGenderProbability(mention.getGenderProb());
                }
                if (entity.getNumberProbability() < mention.getNumberProb()) {
                    entity.setNumber(mention.getNumber());
                    entity.setNumberProbability(mention.getNumberProb());
                }
                entity.addMention(mention);
                dm.mentionEntity(entity);
            } else {
                entity = new DiscourseEntity(mention, mention.getGender(), mention.getGenderProb(), mention.getNumber(), mention.getNumberProb());
                dm.addEntity(entity);
            }
        } else if (entity != null) {
            DiscourseEntity newEntity = new DiscourseEntity(mention, mention.getGender(), mention.getGenderProb(), mention.getNumber(), mention.getNumberProb());
            dm.addEntity(newEntity);
            newEntity.setId(entity.getId());
        } else {
            DiscourseEntity newEntity = new DiscourseEntity(mention, mention.getGender(), mention.getGenderProb(), mention.getNumber(), mention.getNumberProb());
            dm.addEntity(newEntity);
        }
    }

    protected DiscourseEntity checkForMerges(DiscourseModel dm, DiscourseEntity[] des) {
        DiscourseEntity de1 = des[0];
        for (int di = 1; di < des.length; ++di) {
            DiscourseEntity de2 = des[di];
            if (de2 == null) continue;
            if (de1 != null && de1 != de2) {
                dm.mergeEntities(de1, de2, 1.0f);
                continue;
            }
            de1 = de2;
        }
        return de1;
    }

    public DiscourseEntity[] getEntities(Mention[] mentions) {
        MentionContext[] extentContexts = this.constructMentionContexts(mentions);
        DiscourseModel dm = new DiscourseModel();
        for (int ei = 0; ei < extentContexts.length; ++ei) {
            this.resolve(extentContexts[ei], dm);
        }
        return dm.getEntities();
    }

    public void setEntities(Mention[] mentions) {
        this.getEntities(mentions);
    }

    public void train() throws IOException {
        for (int ri = 0; ri < this.resolvers.length; ++ri) {
            this.resolvers[ri].train();
        }
    }

    public MentionFinder getMentionFinder() {
        return this.mentionFinder;
    }

    public MentionContext[] constructMentionContexts(Mention[] mentions) {
        int mentionInSentenceIndex = -1;
        int numMentionsInSentence = -1;
        int prevSentenceIndex = -1;
        MentionContext[] contexts = new MentionContext[mentions.length];
        int mn = mentions.length;
        for (int mi = 0; mi < mn; ++mi) {
            int sentenceIndex;
            Parse mentionParse = mentions[mi].getParse();
            if (mentionParse == null) {
                System.err.println("no parse for " + mentions[mi]);
            }
            if ((sentenceIndex = mentionParse.getSentenceNumber()) != prevSentenceIndex) {
                mentionInSentenceIndex = 0;
                prevSentenceIndex = sentenceIndex;
                numMentionsInSentence = 0;
                for (int msi = mi; msi < mentions.length && sentenceIndex == mentions[msi].getParse().getSentenceNumber(); ++msi) {
                    ++numMentionsInSentence;
                }
            }
            contexts[mi] = new MentionContext(mentions[mi], mentionInSentenceIndex, numMentionsInSentence, mi, sentenceIndex, this.getHeadFinder());
            contexts[mi].setId(mentions[mi].getId());
            ++mentionInSentenceIndex;
            if (this.mode == LinkerMode.SIM) continue;
            Gender g = this.computeGender(contexts[mi]);
            contexts[mi].setGender(g.getType(), g.getConfidence());
            Number n = this.computeNumber(contexts[mi]);
            contexts[mi].setNumber(n.getType(), n.getConfidence());
        }
        return contexts;
    }

    protected abstract Gender computeGender(MentionContext var1);

    protected abstract Number computeNumber(MentionContext var1);
}

