/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import opennlp.tools.ngram.Token;
import opennlp.tools.util.Span;

public class NameSample {
    private final Token[] sentence;
    private final Span[] names;
    private final String[] nameTypes;
    private final String[][] additionalContext;
    private final boolean isClearAdaptiveData;

    public NameSample(Token[] sentence, Span[] names, String[] types, String[][] additionalContext, boolean clearAdaptiveData) {
        if (sentence == null) {
            throw new IllegalArgumentException();
        }
        if (names == null) {
            names = new Span[]{};
        }
        this.sentence = sentence;
        this.names = names;
        this.additionalContext = additionalContext;
        this.isClearAdaptiveData = clearAdaptiveData;
        this.nameTypes = types;
    }

    public NameSample(Token[] sentence, Span[] names, boolean clearAdaptiveData) {
        this(sentence, names, null, null, clearAdaptiveData);
    }

    public NameSample(Token[] sentence, Span[] names, String[] nameTypes, boolean clearAdaptiveData) {
        this(sentence, names, nameTypes, null, clearAdaptiveData);
    }

    public Token[] getSentence() {
        return this.sentence;
    }

    public Span[] getNames() {
        return this.names;
    }

    public String[] getNameTypes() {
        return this.nameTypes;
    }

    public String[][] getAdditionalContext() {
        return this.additionalContext;
    }

    public boolean isClearAdaptiveDataSet() {
        return this.isClearAdaptiveData;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int tokenIndex = 0; tokenIndex < this.sentence.length; ++tokenIndex) {
            for (int nameIndex = 0; nameIndex < this.names.length; ++nameIndex) {
                if (this.names[nameIndex].getStart() == tokenIndex) {
                    if (this.nameTypes == null) {
                        result.append("<START>").append(' ');
                    } else {
                        result.append("<").append(this.names[nameIndex]).append("> ");
                    }
                }
                if (this.names[nameIndex].getEnd() != tokenIndex) continue;
                if (this.nameTypes == null) {
                    result.append("<END>").append(' ');
                    continue;
                }
                result.append("</").append(this.names[nameIndex]).append("> ");
            }
            result.append(this.sentence[tokenIndex].getToken() + ' ');
        }
        for (int nameIndex = 0; nameIndex < this.names.length; ++nameIndex) {
            if (this.names[nameIndex].getEnd() != this.sentence.length) continue;
            if (this.nameTypes == null) {
                result.append("<END> ");
                continue;
            }
            result.append("</").append(this.names[nameIndex]).append("> ");
        }
        result.setLength(result.length() - 1);
        return result.toString();
    }
}

