/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.muc;

import java.io.IOException;
import java.util.ArrayList;
import opennlp.tools.formats.muc.RawCorefSample;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameFinderCorefEnhancerStream
extends FilterObjectStream<RawCorefSample, RawCorefSample> {
    private TokenNameFinder[] nameFinders;
    private String[] tags;

    protected NameFinderCorefEnhancerStream(TokenNameFinder[] nameFinders, String[] tags, ObjectStream<RawCorefSample> samples) {
        super(samples);
        this.nameFinders = nameFinders;
        this.tags = tags;
    }

    @Override
    public RawCorefSample read() throws IOException {
        RawCorefSample sample = (RawCorefSample)this.samples.read();
        if (sample != null) {
            for (TokenNameFinder namefinder : this.nameFinders) {
                namefinder.clearAdaptiveData();
            }
            ArrayList<Parse> parses = new ArrayList<Parse>();
            for (Parse p : sample.getParses()) {
                int i;
                Parse[] parseTokens = p.getTagNodes();
                String[] tokens = new String[parseTokens.length];
                for (i = 0; i < tokens.length; ++i) {
                    tokens[i] = parseTokens[i].toString();
                }
                for (i = 0; i < this.nameFinders.length; ++i) {
                    Span[] names = this.nameFinders[i].find(tokens);
                    Parse.addNames(this.tags[i], names, parseTokens);
                }
                parses.add(p);
            }
            sample.setParses(parses);
            return sample;
        }
        return null;
    }
}

