% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAmain.r
\name{plotVA}
\alias{plotVA}
\title{Plot top CSMF for a fitted model}
\usage{
plotVA(object, top = 10, title = NULL, ...)
}
\arguments{
\item{object}{a fitted object using \code{\link{codeVA}}}

\item{top}{number of top causes to plot}

\item{title}{title of the plot}

\item{...}{additional arguments passed to \code{\link[InSilicoVA]{plot.insilico}}, 
\code{\link[Tariff]{plot.tariff}}, \code{\link[InterVA4]{CSMF}}, or plot.nbc function in the nbc4va package.}
}
\description{
Plot top CSMF for a fitted model
}
\examples{
\donttest{
data(RandomVA3)
test <- RandomVA3[1:200, ]
train <- RandomVA3[201:400, ]
fit1 <- codeVA(data = test, data.type = "customize", model = "InSilicoVA",
                    data.train = train, causes.train = "cause",
                    Nsim=1000, auto.length = FALSE)

fit2 <- codeVA(data = test, data.type = "customize", model = "InterVA",
               data.train = train, causes.train = "cause",
               version = "4.02", HIV = "h", Malaria = "l")

fit3 <- codeVA(data = test, data.type = "customize", model = "Tariff",
               data.train = train, causes.train = "cause", 
               nboot.sig = 100)

plotVA(fit1)
plotVA(fit2)
plotVA(fit3)
}
}
\seealso{
\code{\link[InSilicoVA]{plot.insilico}} in package \pkg{InSilicoVA}, \code{\link[InterVA4]{CSMF}} in package \pkg{InterVA4}, \code{\link{CSMF5}} in package \pkg{InterVA5}, \code{\link[Tariff]{plot.tariff}} in package \pkg{Tariff}.

Other visualization: 
\code{\link{stackplotVA}()}
}
\concept{visualization}
