% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importAQE.R
\name{importAQE}
\alias{importAQE}
\title{Air Quality England Network data import for openair}
\usage{
importAQE(
  site = "yk13",
  year = 2018,
  pollutant = "all",
  meta = FALSE,
  to_narrow = FALSE
)
}
\arguments{
\item{site}{Site code of the AQE site to import e.g. "yk13" is York Heworth
Green. Several sites can be imported with \code{site = c("yk13", "yk16")}
--- to import York Heworth Green and York Fulford Road Roadside for
example.}

\item{year}{Year or years to import. To import a sequence of years from 1990
to 2000 use \code{year = 1990:2000}. To import several specific years use
\code{year = c(1990, 1995, 2000)} for example.}

\item{pollutant}{Pollutants to import. If omitted will import all pollutants
from a site. To import only NOx and NO2 for example use \code{pollutant =
c("nox", "no2")}.}

\item{meta}{Should meta data be returned? If \code{TRUE} the site type,
latitude and longitude are returned.}

\item{to_narrow}{By default the returned data has a column for each
pollutant/variable. When \code{to_narrow = TRUE} the data are stacked into
a narrow format with a column identifying the pollutant name.}
}
\value{
Returns a data frame of hourly mean values with date in POSIXct
  class and time zone GMT.
}
\description{
Function for importing hourly mean Air Quality England (AQE) archive data
files for use with the \code{openair} package. Files are imported from a
remote server operated by Ricardo that provides air quality data files as R
data objects.
}
\details{
The \code{importAQE} function has been written to make it easy to import
data from the Air Quality England (AQE) ---
\url{https://www.airqualityengland.co.uk/}. Ricardo have provided .RData
files (R workspaces) of all individual sites and years for the AQE. These
files are updated on a daily basis. This approach requires a link to the
Internet to work.

For a list of up to date site codes and site information, see
\code{\link{importMeta}} and in particular \code{importMeta(source =
"aqe")}.

The site codes and pollutant names can be upper or lower case. The function
will issue a warning when data less than six months old is downloaded, which
may not be ratified.
}
\examples{

## see what sites are available
\dontrun{meta <- importMeta("aqe")}

## import all pollutants from York Fulford Road
\dontrun{yk16 <- importAQE(site = "yk16", year = 2010:2018)}

## return meta data also
\dontrun{yk16 <- importAQE(site = "yk16", year = 2018, meta = TRUE)}

## import all pollutants from two sites for 2018
\dontrun{all <- importAQE(site = c("yk13", "yk16"), year = 2018)}


}
\seealso{
See family of air quality neiwork import functions including
  \code{\link{importAURN}} for data elsewhere in the UK and
  \code{\link{importKCL}} for importing comprehensive data in and around
  London.
}
\author{
David Carslaw and Trevor Davies
}
\keyword{methods}
