% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traj_trajMap.R
\name{trajMapStatic}
\alias{trajMapStatic}
\title{Trajectory line plots in \code{ggplot2}}
\usage{
trajMapStatic(
  data,
  colour = "height",
  facet = NULL,
  group = NULL,
  longitude = "lon",
  latitude = "lat",
  npoints = 12,
  xlim = NULL,
  ylim = NULL,
  crs = sf::st_crs(3812),
  origin = TRUE,
  map = TRUE,
  map.fill = "grey85",
  map.colour = "grey75",
  map.alpha = 0.8,
  map.lwd = 0.5,
  map.lty = 1,
  ...
)
}
\arguments{
\item{data}{Data frame, the result of importing a trajectory file using
\code{\link[openair:importTraj]{openair::importTraj()}}.}

\item{colour}{Column to be used for colouring each trajectory. This column
may be numeric, character or factor. This will commonly be a pollutant
concentration which has been joined (e.g., by \code{\link[dplyr:mutate-joins]{dplyr::left_join()}}) to the
trajectory data by "date".}

\item{facet}{Used for splitting the trajectories into different panels.
Passed to \code{\link[openair:cutData]{openair::cutData()}}.}

\item{group}{By default, trajectory paths are distinguished using the arrival
date. \code{group} allows for additional columns to be used (e.g.,
\code{"receptor"}).}

\item{latitude, longitude}{The decimal latitude/longitude.}

\item{npoints}{A dot is placed every \code{npoints} along each full trajectory.
For hourly back trajectories points are plotted every \code{npoints} hours. This
helps to understand where the air masses were at particular times and get a
feel for the speed of the air (points closer together correspond to slower
moving air masses). Defaults to \code{12}.}

\item{xlim, ylim}{The x- and y-limits of the plot. If \code{NULL}, limits will be
estimated based on the lat/lon ranges of the input data.}

\item{crs}{The coordinate reference system (CRS) into which all data should
be projected before plotting. Defaults to the Lambert projection
(\code{sf::st_crs(3812)}). Alternatively, can be set to \code{NULL}, which will
typically render the map quicker but may cause countries far from the
equator or large areas to appear distorted.}

\item{origin}{Should the receptor point be marked with a circle? Defaults to
\code{TRUE}.}

\item{map}{Should a base map be drawn? Defaults to \code{TRUE}.}

\item{map.fill}{Colour to use to fill the polygons of the base map (see
\code{colors()}).}

\item{map.colour}{Colour to use for the polygon borders of the base map (see
\code{colors()}).}

\item{map.alpha}{Transparency of the base map polygons. Must be between \code{0}
(fully transparent) and \code{1} (fully opaque).}

\item{map.lwd}{Line width of the base map polygon borders.}

\item{map.lty}{Line type of the base map polygon borders. See
\code{\link[ggplot2:scale_linetype]{ggplot2::scale_linetype()}} for common examples.}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:ggsf]{ggplot2::coord_sf}}
  \describe{
    \item{\code{expand}}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.}
    \item{\code{datum}}{CRS that provides datum to use when generating graticules.}
    \item{\code{label_graticule}}{Character vector indicating which graticule lines should be labeled
where. Meridians run north-south, and the letters \code{"N"} and \code{"S"} indicate that
they should be labeled on their north or south end points, respectively.
Parallels run east-west, and the letters \code{"E"} and \code{"W"} indicate that they
should be labeled on their east or west end points, respectively. Thus,
\code{label_graticule = "SW"} would label meridians at their south end and parallels at
their west end, whereas \code{label_graticule = "EW"} would label parallels at both
ends and meridians not at all. Because meridians and parallels can in general
intersect with any side of the plot panel, for any choice of \code{label_graticule} labels
are not guaranteed to reside on only one particular side of the plot panel. Also,
\code{label_graticule} can cause labeling artifacts, in particular if a graticule line
coincides with the edge of the plot panel. In such circumstances, \code{label_axes} will
generally yield better results and should be used instead.

This parameter can be used alone or in combination with \code{label_axes}.}
    \item{\code{label_axes}}{Character vector or named list of character values
specifying which graticule lines (meridians or parallels) should be labeled on
which side of the plot. Meridians are indicated by \code{"E"} (for East) and
parallels by \code{"N"} (for North). Default is \code{"--EN"}, which specifies
(clockwise from the top) no labels on the top, none on the right, meridians
on the bottom, and parallels on the left. Alternatively, this setting could have been
specified with \code{list(bottom = "E", left = "N")}.

This parameter can be used alone or in combination with \code{label_graticule}.}
    \item{\code{lims_method}}{Method specifying how scale limits are converted into
limits on the plot region. Has no effect when \code{default_crs = NULL}.
For a very non-linear CRS (e.g., a perspective centered
around the North pole), the available methods yield widely differing results, and
you may want to try various options. Methods currently implemented include \code{"cross"}
(the default), \code{"box"}, \code{"orthogonal"}, and \code{"geometry_bbox"}. For method \code{"cross"},
limits along one direction (e.g., longitude) are applied at the midpoint of the
other direction (e.g., latitude). This method avoids excessively large limits for
rotated coordinate systems but means that sometimes limits need to be expanded a
little further if extreme data points are to be included in the final plot region.
By contrast, for method \code{"box"}, a box is generated out of the limits along both directions,
and then limits in projected coordinates are chosen such that the entire box is
visible. This method can yield plot regions that are too large. Finally, method
\code{"orthogonal"} applies limits separately along each axis, and method
\code{"geometry_bbox"} ignores all limit information except the bounding boxes of any
objects in the \code{geometry} aesthetic.}
    \item{\code{ndiscr}}{Number of segments to use for discretising graticule lines;
try increasing this number when graticules look incorrect.}
    \item{\code{default}}{Is this the default coordinate system? If \code{FALSE} (the default),
then replacing this coordinate system with another one creates a message alerting
the user that the coordinate system is being replaced. If \code{TRUE}, that warning
is suppressed.}
    \item{\code{clip}}{Should drawing be clipped to the extent of the plot panel? A
setting of \code{"on"} (the default) means yes, and a setting of \code{"off"}
means no. In most cases, the default of \code{"on"} should not be changed,
as setting \code{clip = "off"} can cause unexpected results. It allows
drawing of data points anywhere on the plot, including in the plot margins. If
limits are set via \code{xlim} and \code{ylim} and some data points fall outside those
limits, then those data points may show up in places such as the axes, the
legend, the plot title, or the plot margins.}
  }}
}
\value{
a \code{ggplot2} plot
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function plots back trajectories using \code{ggplot2}. The function
requires that data are imported using \code{\link[openair:importTraj]{openair::importTraj()}}. It is a
\code{ggplot2} implementation of \code{\link[openair:trajPlot]{openair::trajPlot()}} with many of the same
arguments, which should be more flexible for post-hoc changes.
}
\examples{
\dontrun{
# colour by height
trajMapStatic(traj_data) +
  ggplot2::scale_color_gradientn(colors = openair::openColours())

# colour by PM10, log transform scale
trajMapStatic(traj_data, colour = "pm10") +
  ggplot2::scale_color_viridis_c(trans = "log10") +
  ggplot2::labs(color = openair::quickText("PM10"))

# color by PM2.5, lat/lon projection
trajMapStatic(traj_data, colour = "pm2.5", crs = sf::st_crs(4326)) +
  ggplot2::scale_color_viridis_c(option = "turbo") +
  ggplot2::labs(color = openair::quickText("PM2.5"))
}
}
\seealso{
the original \code{\link[openair:trajPlot]{openair::trajPlot()}}

\code{\link[=trajMap]{trajMap()}} for the interactive \code{leaflet} equivalent of
\code{\link[=trajMapStatic]{trajMapStatic()}}

Other static trajectory maps: 
\code{\link{trajLevelMapStatic}()}
}
\concept{static trajectory maps}
