% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chat.R
\name{chat}
\alias{chat}
\title{chat Class}
\description{
chat Class

chat Class
}
\section{Super class}{
\code{\link[openaistream:openai]{openaistream::openai}} -> \code{chat}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-chat-create}{\code{chat$create()}}
\item \href{#method-chat-clone}{\code{chat$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="openaistream" data-topic="openai" data-id="initialize"><a href='../../openaistream/html/openai.html#method-openai-initialize'><code>openaistream::openai$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-chat-create"></a>}}
\if{latex}{\out{\hypertarget{method-chat-create}{}}}
\subsection{Method \code{create()}}{
Creates a model response for the given chat conversation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{chat$create(messages, model, stream = F, n = 1, num = 2, verbosity = 0, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{messages}}{list Required. A list of messages comprising the conversation so far.}

\item{\code{model}}{character Required. The model to use for generating chat completions.}

\item{\code{stream}}{logical. Whether to stream back partial progress. If set, tokens will be sent
as data-only server-sent events as they become available.}

\item{\code{n}}{integer. How many chat completion choices to generate for each input message. Note that you will be
charged based on the number of generated tokens across all of the choices. Keep n as 1 to minimize costs.
NOTE: The parameter sometimes fails to work when 'num' is not assigned a value, and the reason for this
is currently unclear. When failure occurs, try assigning any integer greater than 0 to the 'num' parameter.}

\item{\code{num}}{The num parameter controls the number of text entries returned by a stream in one go.
Note that this is different from the n parameter, which specifies the number of results returned.
For detailed information on the n parameter, please refer to OpenAI's API documentation.}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:max_tokens;n;stop;temperature......}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a chat completion object, or a streamed sequence of chat completion chunk objects if the request is streamed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-chat-clone"></a>}}
\if{latex}{\out{\hypertarget{method-chat-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{chat$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
