% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oa2df.R
\name{funders2df}
\alias{funders2df}
\title{Convert OpenAlex collection of funders' records from list format to data frame}
\usage{
funders2df(
  data,
  verbose = TRUE,
  pb = if (verbose) oa_progress(length(data)) else NULL
)
}
\arguments{
\item{data}{List. Output of \code{oa_request}.}

\item{verbose}{Logical.
If TRUE, print information about the dataframe conversion process.
Defaults to TRUE.}

\item{pb}{Progress bar object. If verbose, computed from `oa_progress`.
NULL otherwise.}
}
\value{
a data.frame.

For more extensive information about OpenAlex API, please visit: <https://docs.openalex.org>
}
\description{
It converts bibliographic collection of funders' records gathered from OpenAlex database \href{https://openalex.org/}{https://openalex.org/} into data frame.
The function converts a list of funders' records obtained using \code{oa_request} into a data frame/tibble.
}
\examples{
\dontrun{

# Get funders located in Canada with more than 100,000 citations

res <- oa_request(
  "https://api.openalex.org/funders?filter=country_code:ca,cited_by_count:>100000"
)

df <- oa2df(res, entity = "funders")

df
}

}
