% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-loans_full_schema.R
\docType{data}
\name{loans_full_schema}
\alias{loans_full_schema}
\alias{loan50}
\title{Loan data from Lending Club}
\format{
A data frame with 10,000 observations on the following 55 variables.
\describe{
  \item{emp_title}{Job title.}
  \item{emp_length}{Number of years in the job, rounded down.
      If longer than 10 years, then this is represented by the value
      \code{10}.}
  \item{state}{Two-letter state code.}
  \item{home_ownership}{The ownership status of the
      applicant's residence.}
  \item{annual_income}{Annual income.}
  \item{verified_income}{Type of verification
      of the applicant's income.}
  \item{debt_to_income}{Debt-to-income ratio.}
  \item{annual_income_joint}{If this is a joint application,
      then the annual income of the two parties applying.}
  \item{verification_income_joint}{Type of verification of
      the joint income.}
  \item{debt_to_income_joint}{Debt-to-income ratio for the
      two parties.}
  \item{delinq_2y}{Delinquencies on lines of credit in the
      last 2 years.}
  \item{months_since_last_delinq}{Months since the last
      delinquency.}
  \item{earliest_credit_line}{Year of the applicant's
      earliest line of credit}
  \item{inquiries_last_12m}{Inquiries into the applicant's
      credit during the last 12 months.}
  \item{total_credit_lines}{Total number of credit lines
      in this applicant's credit history.}
  \item{open_credit_lines}{Number of currently open lines
      of credit.}
  \item{total_credit_limit}{Total available credit, e.g.
      if only credit cards, then the total of all the credit limits.
      This excludes a mortgage.}
  \item{total_credit_utilized}{Total credit balance,
      excluding a mortgage.}
  \item{num_collections_last_12m}{Number of collections
      in the last 12 months. This excludes medical collections.}
  \item{num_historical_failed_to_pay}{The number of
      derogatory public records, which roughly means the
      number of times the applicant failed to pay.}
  \item{months_since_90d_late}{Months since the last time
      the applicant was 90 days late on a payment.}
  \item{current_accounts_delinq}{Number of accounts where
      the applicant is currently delinquent.}
  \item{total_collection_amount_ever}{The total amount
      that the applicant has had against them in collections.}
  \item{current_installment_accounts}{Number of installment
      accounts, which are (roughly) accounts with a fixed payment
      amount and period. A typical example might be a 36-month
      car loan.}
  \item{accounts_opened_24m}{Number of new lines of credit
      opened in the last 24 months.}
  \item{months_since_last_credit_inquiry}{Number of months
      since the last credit inquiry on this applicant.}
  \item{num_satisfactory_accounts}{Number of satisfactory
      accounts.}
  \item{num_accounts_120d_past_due}{Number of current
      accounts that are 120 days past due.}
  \item{num_accounts_30d_past_due}{Number of current
      accounts that are 30 days past due.}
  \item{num_active_debit_accounts}{Number of currently
      active bank cards.}
  \item{total_debit_limit}{Total of all bank card limits.}
  \item{num_total_cc_accounts}{Total number of credit card
      accounts in the applicant's history.}
  \item{num_open_cc_accounts}{Total number of currently
      open credit card accounts.}
  \item{num_cc_carrying_balance}{Number of credit cards
      that are carrying a balance.}
  \item{num_mort_accounts}{Number of mortgage accounts.}
  \item{account_never_delinq_percent}{Percent of all lines
      of credit where the applicant was never delinquent.}
  \item{tax_liens}{a numeric vector}
  \item{public_record_bankrupt}{Number of bankruptcies
      listed in the public record for this applicant.}
  \item{loan_purpose}{The category for the purpose
      of the loan.}
  \item{application_type}{The type of application: either
      \code{individual} or \code{joint}.}
  \item{loan_amount}{The amount of the loan the
      applicant received.}
  \item{term}{The number of months of the loan
      the applicant received.}
  \item{interest_rate}{Interest rate of the loan
      the applicant received.}
  \item{installment}{Monthly payment for the loan the
  applicant received.}
  \item{grade}{Grade associated with the loan.}
  \item{sub_grade}{Detailed grade associated with the loan.}
  \item{issue_month}{Month the loan was issued.}
  \item{loan_status}{Status of the loan.}
  \item{initial_listing_status}{Initial listing status
  of the loan. (I think this has to do with whether the
  lender provided the entire loan or if the loan is across
  multiple lenders.)}
  \item{disbursement_method}{Dispersement method of the loan.}
  \item{balance}{Current balance on the loan.}
  \item{paid_total}{Total that has been paid on the loan by the
  applicant.}
  \item{paid_principal}{The difference between the original loan
  amount and the current balance on the loan.}
  \item{paid_interest}{The amount of interest paid so far by the
  applicant.}
  \item{paid_late_fees}{Late fees paid by the applicant.}
}
}
\source{
This data comes from Lending Club
(\url{https://www.lendingclub.com/info/statistics.action}), which
provides a very large, open set of data on the people who received loans
through their platform.
}
\usage{
loans_full_schema
}
\description{
This data set represents thousands of loans made through the Lending Club
platform, which is a platform that allows individuals to lend to other
individuals. Of course, not all loans are created equal. Someone who is a
essentially a sure bet to pay back a loan will have an easier time getting a
loan with a low interest rate than someone who appears to be riskier. And
for people who are very risky? They may not even get a loan offer, or they
may not have accepted the loan offer due to a high interest rate. It is
important to keep that last part in mind, since this data set only
represents loans actually made, i.e. do not mistake this data for loan
applications!
}
\examples{

loans_full_schema


}
\keyword{datasets}
