% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play.R
\name{play}
\alias{play}
\title{Play a ModPlug Tracker module}
\usage{
play(mod, sample_rate = 44100L, progress = "vu", duration = NA_real_, ...)
}
\arguments{
\item{mod}{A tracker module object of class \code{openmpt}.}

\item{sample_rate}{Output sample rate when playing the module.}

\item{progress}{Progress printed to console while playing. Should be one of
\code{"vu"} (indicative volume meter), \code{"time"} (shows timer) or \code{"none"} (don't show progress).
If your audio is stuttering you might want to set this to \code{"none"} to save processing speed.}

\item{duration}{Duration in seconds. Play routine will not last longer than this duration.
if set to \code{NA_real_} it is ignored and the module keeps rendering conform the specified \code{\link[=control]{control()}}.}

\item{...}{Ignored}
}
\value{
Returns \code{NULL} invisibly.
}
\description{
Renders a module tracker object of class \code{openmpt} and plays it instantaneously.
}
\examples{
if (interactive() && has_audio_device()) {
  mod <- demo_mod()
  play(mod)
}
}
