% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x25519.R
\name{curve25519}
\alias{curve25519}
\alias{read_ed25519_key}
\alias{read_ed25519_pubkey}
\alias{read_x25519_key}
\alias{read_x25519_pubkey}
\alias{ed25519_sign}
\alias{ed25519_verify}
\alias{x25519_diffie_hellman}
\title{Curve25519}
\usage{
read_ed25519_key(x)

read_ed25519_pubkey(x)

read_x25519_key(x)

read_x25519_pubkey(x)

ed25519_sign(data, key)

ed25519_verify(data, sig, pubkey)

x25519_diffie_hellman(key, pubkey)
}
\arguments{
\item{x}{a 32 byte raw vector with (pub)key data}

\item{data}{raw vector with data to sign or verify}

\item{key}{private key as returned by \code{read_ed25519_key} or \code{ed25519_keygen}}

\item{sig}{raw vector of length 64 with signature as returned by \code{ed25519_sign}}

\item{pubkey}{public key as returned by \code{read_ed25519_pubkey} or \code{key$pubkey}}
}
\description{
Curve25519 is a recently added low-level algorithm that can be used both for
diffie-hellman (called X25519) and for signatures (called ED25519). Note that
these functions are only available when building against version 1.1.1 or
newer of the openssl library. The same functions are also available in the
sodium R package.
}
\examples{
# Generate a keypair
if(openssl_config()$x25519){
key <- ed25519_keygen()
pubkey <- as.list(key)$pubkey

# Sign message
msg <- serialize(iris, NULL)
sig <- ed25519_sign(msg, key)

# Verify the signature
ed25519_verify(msg, sig, pubkey)

# Diffie Hellman example:
key1 <- x25519_keygen()
key2 <- x25519_keygen()

# Both parties can derive the same secret
x25519_diffie_hellman(key1, key2$pubkey)
x25519_diffie_hellman(key2, key1$pubkey)

# Import/export sodium keys
rawkey <- sodium::sig_keygen()
rawpubkey <- sodium::sig_pubkey(rawkey)
key <- read_ed25519_key(rawkey)
pubkey <- read_ed25519_pubkey(rawpubkey)

# To get the raw key data back for use in sodium
as.list(key)$data
as.list(pubkey)$data
}
}
