% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_modify_basefont}
\alias{wb_modify_basefont}
\alias{wb_set_base_font}
\title{Modify the default font}
\usage{
wb_set_base_font(
  wb,
  fontSize = 11,
  fontColour = wb_colour(theme = "1"),
  fontName = "Calibri"
)
}
\arguments{
\item{wb}{A workbook object}

\item{fontSize}{font size}

\item{fontColour}{font colour}

\item{fontName}{Name of a font}
}
\description{
Modify the default font for this workbook
}
\details{
The font name is not validated in anyway.  Excel replaces unknown font names
with Arial. Base font is black, size 11, Calibri.
}
\examples{
## create a workbook
wb <- wb_workbook()
wb$add_worksheet("S1")
## modify base font to size 10 Arial Narrow in red
wb$set_base_font(fontSize = 10, fontColour = "#FF0000", fontName = "Arial Narrow")

wb$add_data("S1", iris)
wb$add_data_table("S1", x = iris, startCol = 10) ## font colour does not affect tables
}
