% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fmt_txt}
\alias{fmt_txt}
\title{format strings independent of the cell style.}
\usage{
fmt_txt(
  x,
  bold = FALSE,
  italic = FALSE,
  underline = FALSE,
  strike = FALSE,
  size = NULL,
  color = NULL,
  font = NULL,
  charset = NULL,
  outline = NULL,
  vertAlign = NULL
)
}
\arguments{
\item{x}{a string or part of a string}

\item{bold}{bold}

\item{italic}{italic}

\item{underline}{underline}

\item{strike}{strike}

\item{size}{the font size}

\item{color}{a wbColor color for the font}

\item{font}{the font name}

\item{charset}{integer value from the table below}

\item{outline}{TRUE or FALSE}

\item{vertAlign}{baseline, superscript, or subscript}
}
\description{
format strings independent of the cell style.
}
\details{
The result is an xml string. It is possible to paste multiple \code{fmt_txt()}
strings together to create a string with differing styles.

\tabular{ll}{
   "Value" \tab "Character Set" \cr
   "0" \tab "ANSI_CHARSET" \cr
   "1" \tab "DEFAULT_CHARSET" \cr
   "2" \tab "SYMBOL_CHARSET" \cr
   "77" \tab "MAC_CHARSET" \cr
   "128" \tab "SHIFTJIS_CHARSET" \cr
   "129" \tab "HANGUL_CHARSET" \cr
   "130" \tab "JOHAB_CHARSET" \cr
   "134" \tab "GB2312_CHARSET" \cr
   "136" \tab "CHINESEBIG5_CHARSET" \cr
   "161" \tab "GREEK_CHARSET" \cr
   "162" \tab "TURKISH_CHARSET" \cr
   "163" \tab "VIETNAMESE_CHARSET" \cr
   "177" \tab "HEBREW_CHARSET" \cr
   "178" \tab "ARABIC_CHARSET" \cr
   "186" \tab "BALTIC_CHARSET" \cr
   "204" \tab "RUSSIAN_CHARSET" \cr
   "222" \tab "THAI_CHARSET" \cr
   "238" \tab "EASTEUROPE_CHARSET" \cr
   "255" \tab "OEM_CHARSET" \cr
}
}
\examples{
fmt_txt("bar", underline = TRUE)
}
