% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss.R
\name{loss}
\alias{loss}
\title{Errors suffered by a sequence of predictions}
\usage{
loss(x, y, loss.type = "square")
}
\arguments{
\item{x}{A vector of length \code{T}
containing the sequence of prediction to be evaluated.}

\item{y}{A vector of length \code{T} that
contains the observations to be predicted.}

\item{loss.type}{A string or a list with a component 'name' specifying
the loss function considered to evaluate the performance. It can be
'square', 'absolute', 'percentage', or 'pinball'. In the case of the pinball loss, the quantile 
can be provided by assigning to loss.type a list of two elements: 
\describe{
     \item{name}{A string defining the name of the loss function (i.e., 'pinball')}
     \item{tau}{ A number in \code{[0,1]} defining the quantile to be predicted. The default value is 0.5 to predict the median.}
}}
}
\value{
A vector of length \code{T} containing the sequence of
instantaneous losses suffered by the prediction \code{x}.
}
\description{
The
function \code{loss} computes the sequence of instantaneous losses suffered
by the predictions in \code{x} to predict the observation in \code{y}.
}
\author{
Pierre Gaillard <pierre@gaillard.me>
}

