% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_prediction.R
\name{opt_prediction}
\alias{opt_prediction}
\title{Optimise random forest for prediction}
\usage{
opt_prediction(
  y = NULL,
  X = NULL,
  X_Test = NULL,
  number.repetitions = 10,
  alpha = 0.15,
  num.trees_values = c(250, 500, 750, 1000, 2000),
  visualisation = c("none", "prediction", "selection"),
  select_for = c("high", "low", "zero"),
  recommendation = c("prediction", "selection", "none"),
  rec.thresh = 1e-06,
  round.recommendation = c("thousand", "hundred", "ten", "none"),
  ...
)
}
\arguments{
\item{y}{A vector containing the response variable in the training data set.}

\item{X}{A data frame containing the explanatory variables in the training data set. The number of rows must be equal to the number of elements in y.}

\item{X_Test}{A data frame containing the explanatory variables of the test data set. If not entered, a test data set will be randomly generated.}

\item{number.repetitions}{Number of repetitions of random forest to estimate the prediction stability.}

\item{alpha}{The number of best individuals to be selected in the test data set based on their predicted response values. If < 1, alpha will be considered to be the relative amount of individuals in the test data set.}

\item{num.trees_values}{A vector containing the numbers of trees to be analysed. If not specified, 250, 500, 750, 1000, and 2000 trees will be analysed.}

\item{visualisation}{Can be set to "prediction" to draw a plot of the prediction stability or "selection" to draw a plot of the selection stability for the numbers of trees to be analysed.}

\item{select_for}{What should be selected? In random forest classification, this must be set to the value of the desired class. In random forest regression, this can be set as "high" (default) to select the individuals with the highest predicted value, "low" to select the individuals with the lowest predicted value, or "zero" to select the individuals which predicted value is closest to zero.}

\item{recommendation}{If set to "prediction" (default) or "selection", a recommendation will be given based on optimised prediction or selection stability. If set to be "none", the function will analyse the stability of random forest with the inserted numbers of trees without giving a recommendation.}

\item{rec.thresh}{If the number of trees leads to an increase of stability smaller or equal to the value specified, this number of trees will be recommended. Default is 1e-6.}

\item{round.recommendation}{Setting to what number the recommended number of trees should be rounded to. Options: "none", "ten", "hundred", "thousand" (default).}

\item{...}{Any other argument from the ranger function.}
}
\value{
An opt_prediction_object containing the recommended number of trees, based on which measure the recommendation was given (prediction or selection), a matrix summarising the estimated stability and computation time of a random forest with the recommended numbers of trees, a matrix containing the calculated stability and computation time for the analysed numbers of trees, and the parameters used to model the relationship between stability and numbers of trees.
}
\description{
Optimising random forest predictions by calculating the prediction stability with certain numbers of trees
}
\examples{
\donttest{
data(SNPdata)
set.seed(123)
result_optpred = opt_prediction(y = SNPdata[,1], X=SNPdata[,-1]) # optimise random forest
summary(result_optpred)
}

}
