% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_stability.R
\name{plot_stability}
\alias{plot_stability}
\title{Plot random forest stability}
\usage{
plot_stability(
  optRF_object,
  measure = c("selection", "importance", "prediction"),
  from = 0,
  to = 1e+05,
  add.recommendation = TRUE,
  add = FALSE,
  ...
)
}
\arguments{
\item{optRF_object}{An optRF_object, either the result from the \link{opt_importance} or the \link{opt_prediction} function.}

\item{measure}{A character string indicating which stability measure is to be plotted. One of "selection" (default, visualises selection stability), "prediction" (visualises prediction stability) or "importance" (visualises variable importance stability).}

\item{from}{Smallest num.trees value to be plotted.}

\item{to}{Greatest num.trees value to be plotted.}

\item{add.recommendation}{When set as TRUE, if a recommendation was stated within the opt_prediction or opt_importance function, the recommended num.trees value as well as the expected random forest stability will be highlighted in the graph}

\item{add}{If FALSE, a new plot will be created, if TRUE, the graph will be added to an existing plot.}

\item{...}{Any other arguments from the plot function.}
}
\value{
A plot showing the estimated stability of random forest for the given num.trees values.
}
\description{
Plot the estimated stability of random forest against certain numbers of trees
}
\examples{
\dontrun{
data(SNPdata)
set.seed(123)
result_optpred = opt_prediction(y = SNPdata[,1], X=SNPdata[,-1]) # optimise random forest
plot_stability(result_optpred, measure = "prediction", add.recommendation = TRUE, add=FALSE)
plot_stability(result_optpred, measure = "selection",  add.recommendation = FALSE, add=TRUE)
}

}
