% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/giniChart.R
\name{giniChart}
\alias{giniChart}
\title{Produce a ROC curve with gini coefficient title}
\usage{
giniChart(pred, act)
}
\arguments{
\item{pred}{Logit/scores/probabilities to be compared against actuals}

\item{act}{This should be a column containing outcomes in a boolean form either as a factor or number}
}
\description{
This function uses ggplot to produce a themed Receiver Operator Curve and
calculates a Gini coefficient based on it.
}
\examples{
  sampledata<- data.frame(val= rnorm(100) , outcome=rbinom(100,1,.8))
  giniChart(sampledata$val,sampledata$outcome)
  
}
\seealso{
\code{AUC} \code{roc} \code{\link{giniCoef}}

Other creditrisk: 
\code{\link{giniCoef}()},
\code{\link{logit.odd}()},
\code{\link{logit.prob}()},
\code{\link{odd.logit}()},
\code{\link{odd.prob}()},
\code{\link{prob.logit}()},
\code{\link{prob.odd}()},
\code{\link{scaledScore}()}
}
\concept{creditrisk}
\keyword{AUROC}
\keyword{gini}
\keyword{roc}
