% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examples.R
\name{exampleData}
\alias{exampleData}
\title{Exemplary data in the required format}
\usage{
exampleData(fileName = "exampleGosling.xlsx")
}
\arguments{
\item{fileName}{Name of the example file. See 'details' section for further explanation of all provided examples.}
}
\value{
The path to the example file on your computer.
}
\description{
optimLanduse comes bundled with exemplary data for land-use optimization. The
files can also be found on your computer in the package folder `./extdata`. These examples
provide some quick applications of the package for demonstration and an example of the expected data
structure of the data. Consider also the
\href{https://github.com/Forest-Economics-Goettingen/optimLanduse/}{GitHub project page} for
exemplary applications of the package.
}
\details{
\emph{exampleGosling.xlsx} contains the freely available data from Gosling et al. (2020). \emph{exampleEmpty.xlsx}
contains a template for your data.
}
\examples{
require(readxl)
path <- exampleData()
read_xlsx(path, col_names = FALSE)
path <- exampleData("exampleGosling.xlsx")
read_xlsx(path, col_names = FALSE)

}
\references{
Gosling, E., Reith, E., Knoke, T. et al. Exploring farmer perceptions of agroforestry via multi-objective optimisation:
a test application in Eastern Panama. Agroforest Syst 94, 2003–2020 (2020). https://doi.org/10.1007/s10457-020-00519-0
}
