% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_multiwave.R
\name{apply_multiwave}
\alias{apply_multiwave}
\alias{apply_multiwave,Multiwave-method}
\title{Apply a basic optimall function to a Multiwave Object}
\usage{
apply_multiwave(x, phase, wave, fun, ...)

\S4method{apply_multiwave}{Multiwave}(x, phase, wave, fun, ...)
}
\arguments{
\item{x}{An Object of class \code{"multiwave"}}

\item{phase}{A numeric or character value specifying the phase of
\code{multiwave} where the desired output should be placed.}

\item{wave}{A numeric or character value specifying the wave of \code{phase}
in \code{multiwave} where the output should be placed.}

\item{fun}{A character value specifying the name of the \code{optimall}
function to apply. The four available functions are:
\code{optimum_allocation},
\code{allocate_wave}, \code{sample_strata}, and \code{merge_samples}.
\itemize{
\item \code{optimum_allocation}: Uses the \code{data} from
the previous wave
(or previous phase if \code{wave = 1}) to determine the optimum sampling
allocation for the specified wave. If used, the output multiwave
object contains an updated \code{"design"} slot in the specified wave.
\item \code{allocate_wave}: Uses the \code{data} from the previous wave
(or previous phase if \code{wave = 1}) to determine the optimum sampling
allocation for the specified wave. If used, the outputted multiwave object
contains an updated \code{"design"} slot in the specified wave.
The default argument when \code{allocate_wave} is applied in a \code{apply_multiwave()} is \code{detailed = TRUE}.
\item \code{sample_strata}: Uses the \code{data} from the previous wave
(or previous phase if \code{wave = 1}) and \code{design}
from current wave to generate a vector of ids to sample for the current
wave. Note that the \code{wave} argument of the standalone
\code{sample_strata()} function does not apply here,
If used, the output multiwave object contains an updated
\code{"samples"} slot in the specified wave.
\item \code{merge_samples}: Uses the \code{data} from the previous wave (or
previous phase if \code{wave = 1}) and \code{sampled_data} from the
specified wave to generate the final, merged data for the current wave.
If used, the output multiwave object contains an updated \code{"data"}
slot in the specified wave. Note that \code{merge_samples} is already a
method for multiwave objects, so calling
it through \code{apply_multiwave} is the exact same as calling it on its
own.}
See documentation of these functions for more details on the
specific uses and arguments.}

\item{...}{Optional arguments to be given to \code{fun}. Not necessary if
the arguments are already provided as named values in the wave, phase,
or overall metadata in the multiwave object. Arguments provided here
will override specifications in the metadata if provided in both places.}
}
\value{
The inputted multiwave object with one slot updated to include the
output of the specified function.

Note that the phase and wave arguments specify where the function
\emph{output} should be placed. \code{apply_multiwave} will determine where
to get the input dataframes from (returning an error if those slots are
empty or invalid) given the specified wave for the output. For example, if
\code{phase = 2, wave = 2, function = "allocate_wave"}, the data to
determine the optimum allocation will be taken from the previous wave
(phase 2, wave 1) and the output multiwave object will have an updated
\code{"design"} slot of phase 2, wave 2.
}
\description{
Given a specified phase and wave of an object of class multiwave,
\code{apply_multiwave} applies one of four \code{optimall} functions
and returns an updated multiwave object with the output of the applied
function in its specified slot.
}
\examples{

library(datasets)

MySurvey <- multiwave(phases = 2, waves = c(1, 3))
set_mw(MySurvey, phase = 1, slot = "data") <-
  dplyr::select(datasets::iris, -Sepal.Width)

# Get Design by applying optimum_allocation
MySurvey <- apply_multiwave(MySurvey,
  phase = 2, wave = 1,
  fun = "optimum_allocation", strata = "Species",
  y = "Sepal.Length",
  nsample = 15,
  method = "WrightII"
)

# or, we can establish function args in the metadata
set_mw(MySurvey, phase = 2, slot = "metadata") <- list(
  strata = "Species",
  nsample = 15,
  y = "Sepal.Length",
  method = "WrightII"
)

# which allows the function to be run without specifying the args
MySurvey <- apply_multiwave(MySurvey,
  phase = 2, wave = 1,
  fun = "optimum_allocation"
)
}
