% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_smds.R
\name{calc_smds}
\alias{calc_smds}
\title{Calculate standardized mean differences for initial and refined strata}
\usage{
calc_smds(
  object = NULL,
  z = NULL,
  X = NULL,
  base_strata = NULL,
  refined_strata = NULL,
  abs = TRUE
)
}
\arguments{
\item{object}{an optional object of class \code{strat},
typically created using \code{\link{strat}()}
or as a result of a call to \code{\link{prop_strat}()}.
If not provided, \code{z} and \code{X} must be specified}

\item{z}{vector of treatment assignment; only used if \code{object} is not supplied}

\item{X}{covariate matrix/data.frame; only used if \code{object} is not supplied}

\item{base_strata}{optional initial stratification for which to calculate SMDs;
only used if \code{object} is not supplied}

\item{refined_strata}{optional refined stratification for which to calculate SMDs;
only used if \code{object} is not supplied}

\item{abs}{boolean whether to return absolute standardized mean differences or raw values.
Default is TRUE for absolute values}
}
\value{
List with two elements, "base" and "refined", each containing
a matrix of standardized mean differences for each stratum (row) and covariate (column).
}
\description{
Summarizes initial and/or refined strata in terms of standardized mean differences (SMDs).
}
\examples{
# Choose 500 patients and 5 covariates to work with for the example
set.seed(15)
samp <- sample(1:nrow(rhc_X), 500)
cov_samp <- sample(1:26, 5)

# Let it create propensity score strata for you and then refine them
ref <- refine(X = rhc_X[samp, cov_samp], z = rhc_X[samp, "z"])

# Look at covariate balance for propensity score and refined strata
calc_smds(object = ref)

}
