% Generated by roxygen2 (4.0.2): do not edit by hand
\name{timeLagLasso.cv}
\alias{timeLagLasso.cv}
\title{Cross-validation function for timeLagLasso}
\usage{
timeLagLasso.cv(x, y, maxlag, lamlist = NULL, minlam = NULL,
  maxlam = NULL, nlam = 10, flmin = 0.01, flmax = 1, intercept = TRUE,
  standardize = TRUE, method = c("Solve.QP", "GG"),
  strongly.ordered = TRUE, nfolds = 10, folds = NULL, maxiter = 500,
  inneriter = 100, iter.gg = 100, trace = FALSE, epsilon = 1e-04)
}
\arguments{
\item{x}{A matrix of predictors, where the rows are the samples and the columns are the predictors}

\item{y}{A vector of observations, where length(y)  equals nrow(x)}

\item{maxlag}{Maximum time-lag variable chosen by user}

\item{lamlist}{Optional vector of values of lambda (the regularization parameter)}

\item{minlam}{Optional minimum value for lambda}

\item{maxlam}{Optional maximum value for lambda}

\item{nlam}{Number of values of lambda to be tried}

\item{flmin}{Fraction of maxlam minlam= flmin*maxlam. If computation is slow, try increasing
flmin to focus on the sparser part of the path; default 1e-2}

\item{flmax}{Multiplication of maxlam maxlam = flmax * maxlam; default 1}

\item{intercept}{True if there is an intercept in the model.}

\item{standardize}{Standardize the data matrix x.}

\item{method}{Two options available, Solve.QP and Generalized Gradient. Details about two options can be seen in the orderedLasso description.}

\item{strongly.ordered}{An option which allows users to order the coefficients in absolute value.}

\item{nfolds}{Number of cross-validation folds}

\item{folds}{(Optional) user-supplied cross-validation folds.  If provided, nfolds is ignored.}

\item{maxiter}{maximum  iterations run by time-lag lasso. Initialized to 500.}

\item{inneriter}{maximum iterations run by orderedLasso. Initialized to 100.}

\item{iter.gg}{Maximum iterations run by generalized gradient. Intialized to 100}

\item{trace}{Output option; trace = TRUE gives verbose output.}

\item{epsilon}{Error tolerance parameter for convergence criterion; default 1e-5}
}
\value{
\item{lamlist}{Vector of lambda values tried}
\item{cv.err}{Estimate of cross-validation error}
\item{cv.se}{Estimated  standard error of cross-validation estimate}
\item{lamhat}{lambda value minimizing cv.err}
\item{folds}{Indices of folds used in cross-validation}
\item{lamhat.1se}{largest lambda value with cv.err less than  or equal to min(cv.err)+ SE}
\item{nonzero}{Vector giving number of non-zero coefficients for each lambda value}
\item{call}{The call to timeLagLasso.cv}
}
\description{
Uses cross-validation to estimate the regularization parameter for timeLagLasso model
}
\examples{
set.seed(3)
n = 50
maxlag = 5
num_rows_needed = n + maxlag + 1
sigma = 4
x = matrix(rnorm(num_rows_needed * 4), nrow = num_rows_needed)
x_new = time_lag_matrix(x, maxlag)
b = c(3,1,1,0,0,
      4,1,0,0,0,
      3,2,1,0,0,
      1,0,0,0,0)
y = x_new \%*\% b + sigma* rnorm(nrow(x_new))
y = as.vector(y)
y = c(y, rnorm(maxlag + 1))
cvmodel = timeLagLasso.cv(x= x, y = y, maxlag = 5, method = "Solve.QP")
}

