% Generated by roxygen2 (4.0.2): do not edit by hand
\name{timeLagLasso}
\alias{timeLagLasso}
\title{Fit a time-lag lasso}
\usage{
timeLagLasso(x, y, lambda, maxlag, intercept = TRUE, standardize = TRUE,
  beta_pos = NULL, beta_neg = NULL, b0 = NULL, strongly.ordered = TRUE,
  maxiter = 500, inneriter = 100, iter.gg = 100, method = c("Solve.QP",
  "GG"), trace = FALSE, epsilon = 1e-05)
}
\arguments{
\item{x}{A matrix of predictors, where the rows are the samples and the columns are the predictors.}

\item{y}{A vector of observations, where length(y)  equals nrow(x).}

\item{lambda}{Regularization parameter(>0).}

\item{maxlag}{maximum time-lag specified by user.}

\item{intercept}{TRUE if there is an intercept in the model. center=FALSE should almost never be used.
This option is available for special uses only.}

\item{standardize}{Standardize the data matrix x.}

\item{beta_pos}{Optional vector of initialization of the positive part of the coefficients.}

\item{beta_neg}{Optional vector of initialization of the negative part of the coefficients.}

\item{b0}{Initialization of the intercept.}

\item{strongly.ordered}{An option which allows users to order each predictor coefficients non-increasing
in absolute value. Details can be seen in the orderedLasso description; default TRUE.}

\item{maxiter}{Maximum  iterations run by time-lag lasso. Initialized to 500.}

\item{inneriter}{Maximum iterations run by orderedLasso. Initialized to 100.}

\item{iter.gg}{Maximum iterations run by generalized gradient. Intialized to 100}

\item{method}{Two options available, Solve.QP and Generalized Gradient}

\item{trace}{Output option; trace = TRUE gives verbose output.}

\item{epsilon}{Error tolerance parameter for convergence criterion; default 1e-5.}
}
\value{
\item{bp}{Estimated coefficients of the positive part}
\item{bn}{Estimated coefficients of the negative part}
\item{beta}{Estimated coefficients of predictors, which are equal to bp - bn}
\item{b0}{Estimated intercept if there is one in the model}
\item{fitted}{Fitted values of y}
\item{maxlag}{Maximum time-lag}
\item{p}{The number of predictors}
\item{type}{Type of model fit, "gaussian" in this case}
}
\description{
Fit a time-lag lasso model. Builds a regression model with multiple predictors, where an ordered constraint is imposed
on each predictor.
}
\details{
First transfer the data matrix x to the correct format corresponding to the maxlag specified by user.
Then use coordinate descent method by calling
orderedLasso to get updates for each predictor.
}
\examples{
set.seed(3)
n = 50
maxlag = 5
num_rows_needed = n + maxlag + 1
sigma = 4
x = matrix(rnorm(num_rows_needed * 4), nrow = num_rows_needed)
x_new = time_lag_matrix(x, maxlag)
b = c(3,1,1,0,0,
      4,1,0,0,0,
      3,2,1,0,0,
      1,0,0,0,0)
y = x_new \%*\% b + sigma* rnorm(nrow(x_new))
y = as.vector(y)
y = c(y, rnorm(maxlag + 1))
model1 = timeLagLasso(x = x, y = y, lambda =  1, maxlag = maxlag, 
          method = "Solve.QP", strongly.ordered = TRUE)
}

