% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{orderly_log_on}
\alias{orderly_log_on}
\alias{orderly_log_off}
\alias{orderly_log}
\title{Orderly logging and diagnostic messages}
\usage{
orderly_log_on()

orderly_log_off()

orderly_log(topic, value)
}
\arguments{
\item{topic}{Up to 9 character text string with the log topic}

\item{value}{Character string with the log entry}
}
\value{
\code{orderly_log_on} and \code{orderly_log_off} invisibly
returns a logical indicating if logging was previously enabled.
This allows patterns like:\preformatted{if (!orderly::orderly_log_off()) \{
  on.exit(orderly::orderly_log_on())
\}
}

to disable logging within a function (the \code{on.exit} block
will be run when the function exits).
}
\description{
Start and stop the orderly log.  When active, some actions will
print diagnostic information to the message stream.  This is set
to be on by default.
}
\details{
The function \code{orderly_log} is designed to be used from
applications that extend orderly, while the functions
\code{orderly_log_on} and \code{orderly_log_off} can be used by
applications or users to enable and disable log messages.

The interface here may expand by adding arguments or change
behaviour based on global options. Future versions may support
logging to a file, or adding timestamps, or logging in json
format, etc.
}
\examples{
# We are going to log things below
logging_was_enabled <- orderly::orderly_log_on()

# About orderly log messages:
# Orderly log messages have the form "[title] message"
orderly::orderly_log_on()
orderly::orderly_log("title", "message")

# If logging is disabled they are not printed:
orderly::orderly_log_off()
orderly::orderly_log("title", "message")

# Restore to previous settings:
if (logging_was_enabled) {
  orderly::orderly_log_on()
}
}
\seealso{
\code{\link[=orderly_run]{orderly_run()}}, which makes use of these log
messages
}
