% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ocmm.R
\name{ocmm}
\alias{ocmm}
\title{Ordinal regression for continuous scales with mixed effects}
\usage{
ocmm(formula, data = NULL, weights, start = NULL, link = c("logit"),
  gfun = c("glf"), method = c("optim", "ucminf"), quad = c("Laplace",
  "GH"), n_nodes = 10)
}
\arguments{
\item{formula}{a formula expression as for regression models, of the form
response ~ predictors. Only mixed-effects models with a single random effect on the intercept are supported.
The model must have an intercept: attempts to remove one will lead to a warning and will be
ignored.}

\item{data}{an optional data frame in which to interpret the variables occurring in the formulas}

\item{weights}{optional case weights in fitting. Defaults to 1.}

\item{start}{a vector of initial values for the regression coefficients,
\code{M},  \code{B}, \code{T}, (offset, slope and symmetry of the g function) and the standard deviation of the random effect}

\item{link}{link function, i.e., the type of location-scale distribution assumed for the latent distribution. The default logit link gives the proportional odds model and is the only link function currently supported.}

\item{gfun}{A smooth monotonic function capable of capturing the non-linear nature of the ordinal measure. It defaults to the generalized logistic function (\code{\link{g_glf}}), which is currently the only possibility.}

\item{method}{The optimizer used to maximize the likelihood function.}

\item{quad}{A string indicating the type of quadrature used to integrate over the random effects. Can take values \code{"Laplace"} (Adaptive Gauss-Hermite quadrature using Laplace approximation; the default) or \code{"GH"} (Gauss-Hermite quadrature).}

\item{n_nodes}{order of Gauss-Hermite rule used (number of nodes)}
}
\value{
An object of type \code{ocmm} with the components listed below.

\item{coefficients}{parameter estimates. The first \code{len_beta} elements
are the estimates of the fixed-effects parameters; the last 4  elements  are the estimates of
the parameters of the g function (\code{M},  \code{B},  and \code{T}) and the standard
deviation of the random effect.}
\item{vcov}{variance-covariance matrix, of dimension (\code{len_beta} +4)x(\code{len_beta} +4
)}
\item{sigma_rnd}{standard deviation of the random effect}
\item{df}{estimated degrees of freedom}
\item{logLik}{value of the log-likelihood at the estimated optimum}
\item{len_beta}{number of fixed-effects parameters of the model}
\item{len_gfun}{number of parameters in the g function used in the model}
\item{len_rnd}{number of random effects (1 in this version of the package)}
\item{fitted.values}{fitted probabilities}
\item{residuals}{residuals on the latent scale}
\item{v}{vector of continuous scores}
\item{x}{model matrix}
\item{sample.size}{sample size (can differ from the number of observations if the weights are different from 1)}
\item{nobs}{number of observations}
\item{call}{call to fit the model}
\item{no.pars}{total number of parameters estimated}
\item{data}{data frame used}
\item{link}{link function used}
\item{gfun}{g function used}
\item{formula}{formula used}
}
\description{
Fits an ordinal continuous mixed model with logit link, using the generalized logistic function as g function.
}
\details{
Fits a continuous ordinal regression model, with fixed and random effects. The g function is the generalized logistic function (see \code{\link{g_glf}}), and the link function is the logit,
implying the standard logistic distribution for the latent variable. Maximum likelihood estimation is performed, using \code{optim {stats}} with a quasi-Newton method (\code{"BFGS"}).
Either adaptive Gauss-Hermite quadrature with the Laplace approximation, or Gauss-Hermite quadrature, is used.
For continuous ordinal  modelling with fixed effects only, see \code{\link{ocm}}.
}
\examples{
\dontrun{
fit.overall.rnd  <- ocmm(overall  ~ cycleno + age + bsa + treatment + (1|randno), data=ANZ0001)
fit.phys.rnd     <- ocmm(phys 	   ~ cycleno + age + bsa + treatment + (1|randno), data=ANZ0001)
fit.pain.rnd 	  <- ocmm(pain 	   ~ cycleno + age + bsa + treatment + (1|randno), data=ANZ0001)
fit.mood.rnd 	  <- ocmm(mood 	   ~ cycleno + age + bsa + treatment + (1|randno), data=ANZ0001)
fit.nausvom.rnd <- ocmm(nausvom ~ cycleno + age + bsa + treatment + (1|randno), data=ANZ0001)
fit.appetite.rnd <- ocmm(appetite ~ cycleno + age + bsa + treatment + (1|randno), data=ANZ0001)
summary(fit.overall.rnd)
summary(fit.phys.rnd)
summary(fit.pain.rnd)
summary(fit.mood.rnd)
summary(fit.nausvom.rnd)
summary(fit.appetite.rnd)
}
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\keyword{likelihood,}
\keyword{log-likelihood,}
\keyword{ordinal}
\keyword{regression.}

