% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.ordinalNetFit}
\alias{predict.ordinalNetFit}
\title{Predict method for an "ordinalNetFit" object}
\usage{
\method{predict}{ordinalNetFit}(object, newx = NULL, whichLambda = NULL,
  criteria = c("aic", "bic"), type = c("response", "class", "link"), ...)
}
\arguments{
\item{object}{An "ordinalNetFit" S3 object.}

\item{newx}{Optional covariate matrix. If NULL, fitted values will be obtained
for the training data, as long as the model was fit with the argument
\code{keepTrainingData=TRUE}.}

\item{whichLambda}{Optional index number of the desired lambda value within
the solution path sequence.}

\item{criteria}{Selects the best lambda value by AIC or BIC. Only used
if \code{whichLambda=NULL}.}

\item{type}{The type of prediction required.  Type "response" returns a
matrix of fitted probabilities. Type "class" returns a vector containing the
class number with the highest fitted probability. Type "link" returns a
matrix of linear predictors.}

\item{...}{Not used. Additional predict arguments.}
}
\value{
The object returned depends on \code{type}.
}
\description{
Obtains predicted probabilities, predicted class, or linear predictors.
}
\examples{
# Simulate x as independent standard normal
# Simulate y|x from an parallel cumulative logit (proportional odds) model
set.seed(1)
n <- 50
intercepts <- c(-1, 1)
beta <- c(1, 1, 0, 0, 0)
ncat <- length(intercepts) + 1  # number of response categories
p <- length(beta)  # number of covariates
x <- matrix(rnorm(n*p), ncol=p)  # n x p covariate matrix
eta <- c(x \%*\% beta) + matrix(intercepts, nrow=n, ncol=ncat-1, byrow=TRUE)
invlogit <- function(x) 1 / (1+exp(-x))
cumprob <- t(apply(eta, 1, invlogit))
prob <- cbind(cumprob, 1) - cbind(0, cumprob)
yint <- apply(prob, 1, function(p) sample(1:ncat, size=1, prob=p))
y <- as.factor(yint)

# Fit parallel cumulative logit model
fit <- ordinalNet(x, y)
predict(fit)
predict(fit, type="class")

}
