% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary.ordinalNetFit}
\alias{summary.ordinalNetFit}
\title{Summary method for an "ordinalNetFit" object.
Provides a model fit summary as a data frame. For each \code{lambda} value in
the solution path, the following information is included: degrees of freedom
(number of nonzero parameters), log-likelihood, AIC, BIC, and percent deviance explained.}
\usage{
\method{summary}{ordinalNetFit}(object, ...)
}
\arguments{
\item{object}{An \code{ordinalNetFit} S3 object}

\item{...}{Not used. Additional summary arguments.}
}
\value{
Data frame with values that summarize the fit of each \code{lambda}
value in the solution path.
}
\description{
Summary method for an "ordinalNetFit" object.
Provides a model fit summary as a data frame. For each \code{lambda} value in
the solution path, the following information is included: degrees of freedom
(number of nonzero parameters), log-likelihood, AIC, BIC, and percent deviance explained.
}
\examples{
# Simulate x as independent standard normal
# Simulate y|x from a parallel cumulative logit (proportional odds) model
set.seed(1)
n <- 50
intercepts <- c(-1, 1)
beta <- c(1, 1, 0, 0, 0)
ncat <- length(intercepts) + 1  # number of response categories
p <- length(beta)  # number of covariates
x <- matrix(rnorm(n*p), ncol=p)  # n x p covariate matrix
eta <- c(x \%*\% beta) + matrix(intercepts, nrow=n, ncol=ncat-1, byrow=TRUE)
invlogit <- function(x) 1 / (1+exp(-x))
cumprob <- t(apply(eta, 1, invlogit))
prob <- cbind(cumprob, 1) - cbind(0, cumprob)
yint <- apply(prob, 1, function(p) sample(1:ncat, size=1, prob=p))
y <- as.factor(yint)

# Fit parallel cumulative logit model
fit <- ordinalNet(x, y)
summary(fit)

}
