% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{check_goodfaith}
\alias{check_goodfaith}
\title{Check Good-Faith Probability}
\usage{
check_goodfaith(project, edits, ...)
}
\arguments{
\item{project}{a Wikimedia project. Supported projects can be obtained with
\code{\link{list_wikis}}.}

\item{edits}{a vector of edit IDs, as integers.}

\item{...}{further arguments to pass to httr's GET.}
}
\value{
A data.frame of five columns; \code{edit}, the
edit ID, \code{project}, the project, \code{prediction},
whether the model predicts that the edit was made in good faith,
\code{false_prob}, the probability that the model's prediction
is wrong, and \code{true_prob}, the probability that the model's
prediction is correct. In the event of an error (due to the edit
not being available) NAs will be returned in that row.
}
\description{
\code{check_goodfaith} identifies whether
or not an edit was made in 'good faith' - whether it was well-intentioned,
even if it is not a high-quality contribution.
}
\examples{
# A simple, single-diff example
goodfaith_data <- check_goodfaith("enwiki", 34854345)

}
\seealso{
\code{\link{check_reverted}} to identify if a set of edits are likely
to be reverted, and \code{\link{check_damaging}} to check if a set of edits
were damaging.
}

