% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_validate.R
\name{cross_validate}
\alias{cross_validate}
\title{Main Cross-Validation Function}
\usage{
cross_validate(cv_fun, folds, ..., .combine = TRUE,
  .combine_control = list(), .old_results = NULL)
}
\arguments{
\item{cv_fun}{a function that takes a 'fold' as it's first argument and
returns a list of results from that fold.}

\item{folds}{a list of folds to loop over generated using
\code{\link{make_folds}}.}

\item{...}{other arguments passed to \code{cvfun}.}

\item{.combine}{(logical) - should \code{\link{combine_results}} be called.}

\item{.combine_control}{(list) - arguments to \code{\link{combine_results}}.}

\item{.old_results}{(list) - the returned result from a previous call to
This function. Will be combined with the current results. This is
useful for adding additional CV folds to a results object.}
}
\value{
A list of results, combined across folds.
}
\description{
Applies \code{cvfun} to the folds using \code{future_lapply} and combines the
results across folds using \code{combine_results}.
}
\examples{
data(mtcars)

# resubstitution MSE
r <- lm(mpg ~ ., data = mtcars)
mean(resid(r)^2)

# function to calculate cross-validated squared error
cvlm <- function(fold) {
    train_data <- training(mtcars)
    valid_data <- validation(mtcars)
    
    r <- lm(mpg ~ ., data = train_data)
    preds <- predict(r, newdata = valid_data)
    list(coef = data.frame(t(coef(r))), SE = ((preds - valid_data$mpg)^2))
    
}

# replicate the resubstitution estimate
resub <- make_folds(mtcars, fold_fun = folds_resubstitution)[[1]]
resub_results <- cvlm(resub)
mean(resub_results$SE)

# cross-validated estimate
folds <- make_folds(mtcars)
results <- cross_validate(cvlm, folds)
mean(results$SE)
}
